/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDelete
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDelete.class);
    private static final String DELETE_HELP_MESSAGE = "task --delete {TASK-KEY} {TASK-KEY} [...]";
    private final Input input;

    public TaskDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.taskSyncopeOperations.delete(parameter);
                    this.taskResultManager.deletedMessage("Task", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting task", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.taskResultManager.notFoundError("Task", parameter);
                        continue;
                    }
                    if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.taskResultManager.genericError("You cannot delete task " + parameter);
                        continue;
                    }
                    this.taskResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting task", (Throwable)ex);
                    this.taskResultManager.notBooleanDeletedError("task", parameter);
                }
            }
        } else {
            this.taskResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

