/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.schema;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.schema.AbstractSchemaCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRead
extends AbstractSchemaCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaRead.class);
    private static final String READ_HELP_MESSAGE = "schema --read {SCHEMA-TYPE} {SCHEMA-KEY}\n   Schema type: PLAIN / DERIVED / VIRTUAL";
    private final Input input;

    public SchemaRead(Input input) {
        this.input = input;
    }

    public void read() {
        block7: {
            if (this.input.parameterNumber() >= 2) {
                String[] parameters = Arrays.copyOfRange(this.input.getParameters(), 1, this.input.parameterNumber());
                try {
                    ArrayList schemaTOs = new ArrayList();
                    for (String parameter : parameters) {
                        schemaTOs.add(this.schemaSyncopeOperations.read(this.input.firstParameter(), parameter));
                    }
                    this.schemaResultManager.toView(this.input.firstParameter(), schemaTOs);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading schema", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.schemaResultManager.notFoundError("Schema", parameters[0]);
                        break block7;
                    }
                    this.schemaResultManager.genericError(ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error reading schema", (Throwable)ex);
                    this.schemaResultManager.typeNotValidError("schema", this.input.firstParameter(), CommandUtils.fromEnumToArray(SchemaType.class));
                }
            } else {
                this.schemaResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

