/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.schema;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.schema.AbstractSchemaCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaListAll
extends AbstractSchemaCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaListAll.class);
    private static final String LIST_HELP_MESSAGE = "schema --list-all";
    private final Input input;

    public SchemaListAll(Input input) {
        this.input = input;
    }

    public void listAll() {
        if (this.input.parameterNumber() == 0) {
            try {
                for (SchemaType schemaType : SchemaType.values()) {
                    this.schemaResultManager.toView(schemaType.name(), this.schemaSyncopeOperations.list(schemaType.name()));
                }
            }
            catch (WebServiceException | SyncopeClientException ex) {
                LOG.error("Error listing schema", ex);
                this.schemaResultManager.genericError(ex.getMessage());
            }
        } else {
            this.schemaResultManager.unnecessaryParameters(this.input.listParameters(), LIST_HELP_MESSAGE);
        }
    }
}

