/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.schema;

import java.util.Arrays;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.schema.AbstractSchemaCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDelete
extends AbstractSchemaCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaDelete.class);
    private static final String DELETE_HELP_MESSAGE = "schema --delete {SCHEMA-TYPE} {SCHEMA-KEY}\n   Schema type: PLAIN / DERIVED / VIRTUAL";
    private final Input input;

    public SchemaDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 2) {
            String[] parameters = Arrays.copyOfRange(this.input.getParameters(), 1, this.input.parameterNumber());
            try {
                for (String parameter : parameters) {
                    this.schemaSyncopeOperations.delete(this.input.firstParameter(), parameter);
                    this.schemaResultManager.deletedMessage("Schema", parameter);
                }
            }
            catch (WebServiceException | SyncopeClientException ex) {
                LOG.error("Error deleting schema", ex);
                if (ex.getMessage().startsWith("NotFound")) {
                    this.schemaResultManager.notFoundError("Schema", parameters[0]);
                }
                if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                    this.schemaResultManager.genericError("You cannot delete schema " + parameters[0]);
                }
                this.schemaResultManager.genericError(ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Error deleting schema", (Throwable)ex);
                this.schemaResultManager.typeNotValidError("schema", this.input.firstParameter(), CommandUtils.fromEnumToArray(SchemaType.class));
            }
        } else {
            this.schemaResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

