/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.role;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.role.AbstractRoleCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDelete
extends AbstractRoleCommand {
    private static final Logger LOG = LoggerFactory.getLogger(RoleDelete.class);
    private static final String DELETE_HELP_MESSAGE = "role --delete {ROLE-KEY} {ROLE-KEY} [...]";
    private final Input input;

    public RoleDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.getParameters().length >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.roleSyncopeOperations.delete(parameter);
                    this.roleResultManager.deletedMessage("role", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting role", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.roleResultManager.notFoundError("Role", parameter);
                    } else {
                        this.roleResultManager.genericError(ex.getMessage());
                    }
                    break;
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting role", (Throwable)ex);
                    this.roleResultManager.numberFormatException("role", parameter);
                }
            }
        } else {
            this.roleResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

