/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.resource;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.resource.AbstractResourceCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDelete
extends AbstractResourceCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDelete.class);
    private static final String DELETE_HELP_MESSAGE = "resource --delete {RESOURCE-KEY} {RESOURCE-KEY} [...]";
    private final Input input;

    public ResourceDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.getParameters().length >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.resourceSyncopeOperations.delete(parameter);
                    this.resourceResultManager.deletedMessage("resource", parameter);
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting resource", (Throwable)ex);
                    this.resourceResultManager.numberFormatException("resource", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting resource", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.resourceResultManager.notFoundError("Resource", parameter);
                    } else {
                        this.resourceResultManager.genericError(ex.getMessage());
                    }
                    break;
                }
            }
        } else {
            this.resourceResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

