/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.resource;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.resource.ResourceDelete;
import org.apache.syncope.client.cli.commands.resource.ResourceDetails;
import org.apache.syncope.client.cli.commands.resource.ResourceList;
import org.apache.syncope.client.cli.commands.resource.ResourceRead;
import org.apache.syncope.client.cli.commands.resource.ResourceResultManager;

@Command(name="resource")
public class ResourceCommand
extends AbstractCommand {
    private final ResourceResultManager resourceResultManager = new ResourceResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(ResourceOptions.HELP.getOptionName());
        }
        switch (ResourceOptions.fromName(input.getOption())) {
            case DETAILS: {
                new ResourceDetails(input).details();
                break;
            }
            case LIST: {
                new ResourceList(input).list();
                break;
            }
            case READ: {
                new ResourceRead(input).read();
                break;
            }
            case DELETE: {
                new ResourceDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.resourceResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.resourceResultManager.commandHelpMessage(this.getClass());
    }

    private static enum ResourceOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        READ("--read"),
        DELETE("--delete");

        private final String optionName;

        private ResourceOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static ResourceOptions fromName(String name) {
            ResourceOptions optionToReturn = HELP;
            for (ResourceOptions option : ResourceOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (ResourceOptions value : ResourceOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

