/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.report.AbstractReportCommand;
import org.apache.syncope.client.cli.commands.report.ReportCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportExecute
extends AbstractReportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReportExecute.class);
    private static final String EXECUTE_HELP_MESSAGE = "report --execute {REPORT-KEY}";
    private final Input input;

    public ReportExecute(Input input) {
        this.input = input;
    }

    public void execute() {
        block7: {
            if (this.input.parameterNumber() == 1) {
                try {
                    this.reportSyncopeOperations.execute(this.input.firstParameter());
                    this.reportResultManager.genericMessage("Report " + this.input.firstParameter() + "executed.");
                    this.reportResultManager.genericMessage("Run " + ReportCommand.ReportOptions.READ.getOptionName() + " " + this.input.firstParameter() + " to see the results.");
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error executin report", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.reportResultManager.notFoundError("Report", this.input.firstParameter());
                        break block7;
                    }
                    if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.reportResultManager.genericError("You cannot delete report " + this.input.firstParameter());
                        break block7;
                    }
                    this.reportResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error executin report", (Throwable)ex);
                    this.reportResultManager.numberFormatException("report", this.input.firstParameter());
                }
            } else {
                this.reportResultManager.commandOptionError(EXECUTE_HELP_MESSAGE);
            }
        }
    }
}

