/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.report.AbstractReportCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ReportTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDetails
extends AbstractReportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDetails.class);
    private static final String LIST_HELP_MESSAGE = "report --details";
    private final Input input;

    public ReportDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
                List<ReportTO> reportTOs = this.reportSyncopeOperations.list();
                long withoutExecutions = reportTOs.stream().filter(reportTO -> reportTO.getExecutions().isEmpty()).count();
                details.put("Total numbers", String.valueOf(reportTOs.size()));
                details.put("Never executed", String.valueOf(withoutExecutions));
                this.reportResultManager.printDetails(details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about report", (Throwable)ex);
                this.reportResultManager.genericError(ex.getMessage());
            }
        } else {
            this.reportResultManager.unnecessaryParameters(this.input.listParameters(), LIST_HELP_MESSAGE);
        }
    }
}

