/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.realm;

import java.util.LinkedHashMap;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.realm.AbstractRealmCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmDetails
extends AbstractRealmCommand {
    private static final Logger LOG = LoggerFactory.getLogger(RealmDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "realm --details";
    private final Input input;

    public RealmDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
                details.put("Total number", String.valueOf(this.realmSyncopeOperations.list().size()));
                this.realmResultManager.printDetails(details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about realm", (Throwable)ex);
                this.realmResultManager.genericError(ex.getMessage());
            }
        } else {
            this.realmResultManager.unnecessaryParameters(this.input.listParameters(), DETAILS_HELP_MESSAGE);
        }
    }
}

