/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.question;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.question.AbstractQuestionCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionRead
extends AbstractQuestionCommand {
    private static final Logger LOG = LoggerFactory.getLogger(QuestionRead.class);
    private static final String READ_HELP_MESSAGE = "question --read {QUESTION-KEY} {QUESTION-KEY} [...]";
    private final Input input;

    public QuestionRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.getParameters().length >= 1) {
            ArrayList<SecurityQuestionTO> questionTOs = new ArrayList<SecurityQuestionTO>();
            for (String parameter : this.input.getParameters()) {
                try {
                    questionTOs.add(this.questionSyncopeOperations.read(parameter));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading question", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.questionResultManager.notFoundError("Security question", parameter);
                        break;
                    }
                    this.questionResultManager.genericError(ex.getMessage());
                    break;
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading question", (Throwable)ex);
                    this.questionResultManager.numberFormatException("security question", parameter);
                }
            }
            this.questionResultManager.printQuestions(questionTOs);
        } else {
            this.questionResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

