/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.question;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.question.QuestionDelete;
import org.apache.syncope.client.cli.commands.question.QuestionList;
import org.apache.syncope.client.cli.commands.question.QuestionRead;
import org.apache.syncope.client.cli.commands.question.QuestionResultManager;

@Command(name="question")
public class QuestionCommand
extends AbstractCommand {
    private final QuestionResultManager questionResultManager = new QuestionResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(QuestionOptions.HELP.getOptionName());
        }
        switch (QuestionOptions.fromName(input.getOption())) {
            case LIST: {
                new QuestionList(input).list();
                break;
            }
            case READ: {
                new QuestionRead(input).read();
                break;
            }
            case DELETE: {
                new QuestionDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.questionResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.questionResultManager.commandHelpMessage(this.getClass());
    }

    private static enum QuestionOptions {
        HELP("--help"),
        LIST("--list"),
        READ("--read"),
        DELETE("--delete");

        private final String optionName;

        private QuestionOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static QuestionOptions fromName(String name) {
            QuestionOptions optionToReturn = HELP;
            for (QuestionOptions option : QuestionOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (QuestionOptions value : QuestionOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

