/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.policy;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.policy.AbstractPolicyCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyList
extends AbstractPolicyCommand {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyList.class);
    private static final String LIST_HELP_MESSAGE = "policy --list {POLICY-TYPE}\n   Policy type: ACCOUNT / PASSWORD / SYNC / PUSH";
    private final Input input;

    public PolicyList(Input input) {
        this.input = input;
    }

    public void list() {
        if (this.input.parameterNumber() == 1) {
            try {
                this.policyResultManager.printPoliciesByType(this.input.firstParameter(), this.policySyncopeOperations.list(this.input.firstParameter()));
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error listing policy", (Throwable)ex);
                this.policyResultManager.genericError(ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Error listing policy", (Throwable)ex);
                this.policyResultManager.typeNotValidError("policy", this.input.firstParameter(), CommandUtils.fromEnumToArray(PolicyType.class));
            }
        } else {
            this.policyResultManager.commandOptionError(LIST_HELP_MESSAGE);
        }
    }
}

