/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.policy;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.policy.AbstractPolicyCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyDelete
extends AbstractPolicyCommand {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyDelete.class);
    private static final String DELETE_HELP_MESSAGE = "policy --delete {POLICY-KEY} {POLICY-KEY} [...]";
    private final Input input;

    public PolicyDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.policySyncopeOperations.delete(parameter);
                    this.policyResultManager.deletedMessage("Policy", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting policy", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.policyResultManager.notFoundError("Policy", parameter);
                        continue;
                    }
                    if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.policyResultManager.genericError("You cannot delete policy " + parameter);
                        continue;
                    }
                    this.policyResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting policy", (Throwable)ex);
                    this.policyResultManager.notBooleanDeletedError("policy", parameter);
                }
            }
        } else {
            this.policyResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

