/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.logger.AbstractLoggerCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerRead
extends AbstractLoggerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerRead.class);
    private static final String READ_HELP_MESSAGE = "logger --read {LOG-NAME} {LOG-NAME} [...]";
    private final Input input;

    public LoggerRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.getParameters().length >= 1) {
            ArrayList<LoggerTO> loggerTOs = new ArrayList<LoggerTO>();
            boolean failed = false;
            for (String parameter : this.input.getParameters()) {
                try {
                    loggerTOs.add(this.loggerSyncopeOperations.read(parameter));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading logger", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.loggerResultManager.notFoundError("Logger", parameter);
                    } else {
                        this.loggerResultManager.genericError(ex.getMessage());
                    }
                    failed = true;
                    break;
                }
            }
            if (!failed) {
                this.loggerResultManager.fromRead(loggerTOs);
            }
        } else {
            this.loggerResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

