/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.logger.AbstractLoggerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerLastStatements
extends AbstractLoggerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerLastStatements.class);
    private static final String READ_HELP_MESSAGE = "logger --last-statements {APPENDER-NAME}";
    private final Input input;

    public LoggerLastStatements(Input input) {
        this.input = input;
    }

    public void read() {
        block5: {
            if (this.input.getParameters().length == 1) {
                try {
                    this.loggerResultManager.fromGetLastLogStatements(this.loggerSyncopeOperations.getLastLogStatements(this.input.getParameters()[0]));
                }
                catch (Exception ex) {
                    LOG.error("Error reading last statements", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.loggerResultManager.notFoundError("Memory appender", this.input.getParameters()[0]);
                        break block5;
                    }
                    this.loggerResultManager.genericError(ex.getMessage());
                }
            } else {
                this.loggerResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

