/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.install;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.ws.rs.ProcessingException;
import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.client.cli.commands.install.InstallConfigFileTemplate;
import org.apache.syncope.client.cli.commands.install.InstallResultManager;
import org.apache.syncope.client.cli.util.FileSystemUtils;
import org.apache.syncope.client.cli.util.JasyptUtils;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallSetupForDebug {
    private static final Logger LOG = LoggerFactory.getLogger(InstallSetupForDebug.class);
    private final InstallResultManager installResultManager = new InstallResultManager();

    public void setup() throws FileNotFoundException, IllegalAccessException {
        this.installResultManager.printWelcome();
        System.out.println("Path to config files of Syncope CLI client will be: " + InstallConfigFileTemplate.dirPath());
        if (!FileSystemUtils.exists(InstallConfigFileTemplate.dirPath())) {
            throw new FileNotFoundException("Directory: " + InstallConfigFileTemplate.dirPath() + " does not exists!");
        }
        if (!FileSystemUtils.canWrite(InstallConfigFileTemplate.dirPath())) {
            throw new IllegalAccessException("Permission denied on " + InstallConfigFileTemplate.dirPath());
        }
        System.out.println("- File system permission checked");
        System.out.println("");
        JasyptUtils jasyptUtils = JasyptUtils.get();
        try {
            String contentCliPropertiesFile = InstallConfigFileTemplate.cliPropertiesFile("http", "localhost", "9080", "/syncope/rest", "admin", jasyptUtils.encrypt("password"));
            FileSystemUtils.createFileWith(InstallConfigFileTemplate.configurationFilePath(), contentCliPropertiesFile);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        try {
            SyncopeService syncopeService = SyncopeServices.get(SyncopeService.class);
            String syncopeVersion = syncopeService.platform().getVersion();
            this.installResultManager.installationSuccessful(syncopeVersion);
        }
        catch (ProcessingException ex) {
            LOG.error("Error installing CLI", (Throwable)ex);
            this.installResultManager.manageProcessingException(ex);
        }
        catch (Exception e) {
            LOG.error("Error installing CLI", (Throwable)e);
            this.installResultManager.manageException(e);
        }
    }
}

