/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.info;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.info.Info;
import org.apache.syncope.client.cli.commands.info.InfoResultManager;
import org.apache.syncope.client.cli.util.CommandUtils;

@Command(name="info")
public class InfoCommand
extends AbstractCommand {
    @Override
    public void execute(Input input) {
        Info info = new Info();
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(Options.HELP.getOptionName());
        }
        switch (Options.fromName(input.getOption())) {
            case VERSION: {
                info.version();
                break;
            }
            case PWD_RESET_ALLOWED: {
                info.pwdResetAllowed();
                break;
            }
            case PWD_RESET_WITH_SECURITY_QUESTION: {
                info.resetWithSecurityQuestion();
                break;
            }
            case SELF_REG_ALLOWED: {
                info.selfRegistrationAllowed();
                break;
            }
            case PROVISIONING_MANAGER: {
                info.provisioningManager();
                break;
            }
            case ACCOUNT_RULES: {
                info.accountRules();
                break;
            }
            case CONNID_LOCATION: {
                info.connidLocations();
                break;
            }
            case RECON_FILTER_BUILDERS: {
                info.reconFilterBuilders();
                break;
            }
            case LOGIC_ACTIONS: {
                info.logicActions();
                break;
            }
            case MAPPING_ITEM_TRANSFORMERS: {
                info.itemTransformers();
                break;
            }
            case PASSWORD_RULES: {
                info.passwordRules();
                break;
            }
            case PROPAGATION_ACTIONS: {
                info.propagationActions();
                break;
            }
            case PUSH_ACTIONS: {
                info.pushActions();
                break;
            }
            case REPORTLET_CONFS: {
                info.reportletConfs();
                break;
            }
            case SYNC_ACTIONS: {
                info.pullActions();
                break;
            }
            case SYNC_CORRELATION_RULES: {
                info.pullCorrelationRules();
                break;
            }
            case TASK_JOBS: {
                info.taskJobs();
                break;
            }
            case VALIDATORS: {
                info.validators();
                break;
            }
            case PASSWORD_GENERATOR: {
                info.passwordGenerator();
                break;
            }
            case VIR_ATTR_CACHE: {
                info.virAttrCache();
                break;
            }
            case HELP: {
                System.out.println(CommandUtils.helpMessage("info", Options.toList()));
                break;
            }
            default: {
                new InfoResultManager().defaultOptionMessage(input.getOption(), CommandUtils.helpMessage("info", Options.toList()));
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return CommandUtils.helpMessage("info", Options.toList());
    }

    private static enum Options {
        VERSION("--version"),
        PWD_RESET_ALLOWED("--pwd-reset-allowed"),
        PWD_RESET_WITH_SECURITY_QUESTION("--pwd-reset-with-question"),
        SELF_REG_ALLOWED("--self-reg-allowed"),
        PROVISIONING_MANAGER("--provisioning-manager-classes"),
        ACCOUNT_RULES("--account-rules-classes"),
        CONNID_LOCATION("--connid-locations"),
        RECON_FILTER_BUILDERS("--reconciliation-filter-builders"),
        LOGIC_ACTIONS("--logic-actions"),
        MAPPING_ITEM_TRANSFORMERS("--mapping-item-transformers"),
        PASSWORD_RULES("--password-rules"),
        PROPAGATION_ACTIONS("--propagation-actions"),
        PUSH_ACTIONS("--push-actions"),
        REPORTLET_CONFS("--reportletConfs"),
        SYNC_ACTIONS("--sync-actions"),
        SYNC_CORRELATION_RULES("--sync-correlation-rules"),
        TASK_JOBS("--task-jobs"),
        VALIDATORS("--validators"),
        PASSWORD_GENERATOR("--password-generator"),
        VIR_ATTR_CACHE("--vir-attr-cache"),
        HELP("--help");

        private final String optionName;

        private Options(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static Options fromName(String name) {
            Options optionToReturn = HELP;
            for (Options option : Options.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (Options value : Options.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

