/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.info;

import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.client.cli.commands.info.InfoResultManager;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Info {
    private static final Logger LOG = LoggerFactory.getLogger(Info.class);
    private final PlatformInfo platformInfo = SyncopeServices.get(SyncopeService.class).platform();
    private final InfoResultManager infoResultManager = new InfoResultManager();

    public void version() {
        try {
            this.infoResultManager.printVersion(this.platformInfo.getVersion());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void pwdResetAllowed() {
        try {
            this.infoResultManager.printPwdResetAllowed(this.platformInfo.isPwdResetAllowed());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void resetWithSecurityQuestion() {
        try {
            this.infoResultManager.printPwdResetRequiringSecurityQuestions(this.platformInfo.isPwdResetRequiringSecurityQuestions());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void selfRegistrationAllowed() {
        try {
            this.infoResultManager.printSelfRegistrationAllowed(this.platformInfo.isSelfRegAllowed());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void provisioningManager() {
        try {
            this.infoResultManager.printProvisioningManager(this.platformInfo.getProvisioningInfo().getAnyObjectProvisioningManager(), this.platformInfo.getProvisioningInfo().getUserProvisioningManager(), this.platformInfo.getProvisioningInfo().getGroupProvisioningManager());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void accountRules() {
        this.platformInfo.getJavaImplInfo(ImplementationType.ACCOUNT_RULE).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void connidLocations() {
        try {
            this.infoResultManager.printConnidLocations(this.platformInfo.getConnIdLocations());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void reconFilterBuilders() {
        this.platformInfo.getJavaImplInfo(ImplementationType.RECON_FILTER_BUILDER).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void logicActions() {
        this.platformInfo.getJavaImplInfo(ImplementationType.LOGIC_ACTIONS).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void itemTransformers() {
        this.platformInfo.getJavaImplInfo(ImplementationType.ITEM_TRANSFORMER).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void passwordRules() {
        this.platformInfo.getJavaImplInfo(ImplementationType.PASSWORD_RULE).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void propagationActions() {
        this.platformInfo.getJavaImplInfo(ImplementationType.PROPAGATION_ACTIONS).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void pushActions() {
        this.platformInfo.getJavaImplInfo(ImplementationType.PUSH_ACTIONS).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void reportletConfs() {
        this.platformInfo.getJavaImplInfo(ImplementationType.REPORTLET).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void pullActions() {
        this.platformInfo.getJavaImplInfo(ImplementationType.PULL_ACTIONS).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void pullCorrelationRules() {
        this.platformInfo.getJavaImplInfo(ImplementationType.PULL_CORRELATION_RULE).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void taskJobs() {
        this.platformInfo.getJavaImplInfo(ImplementationType.TASKJOB_DELEGATE).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void validators() {
        this.platformInfo.getJavaImplInfo(ImplementationType.VALIDATOR).ifPresent(info -> {
            try {
                this.infoResultManager.printAccountRules(info.getClasses());
            }
            catch (Exception ex) {
                LOG.error("Information error", (Throwable)ex);
                this.infoResultManager.genericError(ex.getMessage());
            }
        });
    }

    public void passwordGenerator() {
        try {
            this.infoResultManager.printPasswordGenerator(this.platformInfo.getPasswordGenerator());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }

    public void virAttrCache() {
        try {
            this.infoResultManager.printVirtualAttributeCacheClass(this.platformInfo.getProvisioningInfo().getVirAttrCache());
        }
        catch (Exception ex) {
            LOG.error("Information error", (Throwable)ex);
            this.infoResultManager.genericError(ex.getMessage());
        }
    }
}

