/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.group;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.group.AbstractGroupCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDelete
extends AbstractGroupCommand {
    private static final Logger LOG = LoggerFactory.getLogger(GroupDelete.class);
    private static final String DELETE_HELP_MESSAGE = "group --delete {GROUP-KEY} {GROUP-KEY} [...]";
    private final Input input;

    public GroupDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.groupSyncopeOperations.delete(parameter);
                    this.groupResultManager.deletedMessage("Group", parameter);
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error deleting group", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.groupResultManager.notFoundError("group", parameter);
                        continue;
                    }
                    this.groupResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    this.groupResultManager.numberFormatException("group", parameter);
                }
            }
        } else {
            this.groupResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

