/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.domain;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.domain.AbstractDomainCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainRead
extends AbstractDomainCommand {
    private static final Logger LOG = LoggerFactory.getLogger(DomainRead.class);
    private static final String READ_HELP_MESSAGE = "domain --read {DOMAIN-NAME} {DOMAIN-NAME} [...]";
    private final Input input;

    public DomainRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.domainResultManager.printDomain(this.domainSyncopeOperations.read(parameter));
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error reading domain", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.domainResultManager.notFoundError("Domain", parameter);
                        continue;
                    }
                    this.domainResultManager.genericError(ex.getMessage());
                }
            }
        } else {
            this.domainResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

