/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.connector;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.connector.AbstractConnectorCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorDelete
extends AbstractConnectorCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorDelete.class);
    private static final String DELETE_HELP_MESSAGE = "connector --delete {CONNECTOR-KEY} {CONNECTOR-KEY} [...]";
    private final Input input;

    public ConnectorDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.getParameters().length >= 1) {
            ArrayList<ConnInstanceTO> connInstanceTOs = new ArrayList<ConnInstanceTO>();
            for (String parameter : this.input.getParameters()) {
                try {
                    this.connectorSyncopeOperations.delete(parameter);
                    this.connectorResultManager.deletedMessage("connector", parameter);
                }
                catch (NumberFormatException ex) {
                    this.connectorResultManager.numberFormatException("connector", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting connector", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        LOG.error("Error deleting connector", ex);
                        this.connectorResultManager.notFoundError("Connector", parameter);
                        break;
                    }
                    this.connectorResultManager.genericError(ex.getMessage());
                    break;
                }
            }
            this.connectorResultManager.printConnectors(connInstanceTOs);
        } else {
            this.connectorResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

