/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.configuration;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.configuration.AbstractConfigurationCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationRead
extends AbstractConfigurationCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationRead.class);
    private static final String READ_HELP_MESSAGE = "configuration --read {CONF-NAME} {CONF-NAME} [...]";
    private final Input input;

    public ConfigurationRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.parameterNumber() >= 1) {
            ArrayList<AttrTO> attrList = new ArrayList<AttrTO>();
            boolean failed = false;
            for (String parameter : this.input.getParameters()) {
                try {
                    attrList.add(this.configurationSyncopeOperations.get(parameter));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading configuration", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.configurationResultManager.notFoundError("Configuration", parameter);
                    } else {
                        this.configurationResultManager.genericError(ex.getMessage());
                    }
                    failed = true;
                    break;
                }
            }
            if (!failed) {
                this.configurationResultManager.fromGet(attrList);
            }
        } else {
            this.configurationResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

