/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.anyobject;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.anyobject.AbstractAnyObjectCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyObjectReadAttributesBySchemaType
extends AbstractAnyObjectCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AnyObjectReadAttributesBySchemaType.class);
    private static final String READ_HELP_MESSAGE = "any --read-attr-by-schema-type {ANY_OBJECT-KEY} {SCHEMA-TYPE}\n   Schema type: PLAIN / DERIVED / VIRTUAL";
    private final Input input;

    public AnyObjectReadAttributesBySchemaType(Input input) {
        this.input = input;
    }

    public void read() {
        block7: {
            if (this.input.parameterNumber() == 2) {
                try {
                    this.anyResultManager.printAttributes(this.anySyncopeOperations.readAttributes(this.input.firstParameter(), this.input.secondParameter()));
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error reading any", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.anyResultManager.notFoundError("Any", this.input.firstParameter());
                        break block7;
                    }
                    this.anyResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    this.anyResultManager.numberFormatException("any", this.input.firstParameter());
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error reading schema", (Throwable)ex);
                    this.anyResultManager.typeNotValidError("schema", this.input.secondParameter(), CommandUtils.fromEnumToArray(SchemaType.class));
                }
            } else {
                this.anyResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

