/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.syncope.client.cli.commands.install.InstallConfigFileTemplate;
import org.apache.syncope.client.cli.util.JasyptUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncopeServices {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeServices.class);
    private static String SYNCOPE_ADDRESS;

    private static SyncopeClient client() {
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(Paths.get(InstallConfigFileTemplate.configurationFilePath(), new String[0]), new OpenOption[0]);){
            properties.load(is);
        }
        catch (IOException e) {
            LOG.error("Error opening properties file", (Throwable)e);
        }
        String syncopeAdminPassword = JasyptUtils.get().decrypt(properties.getProperty("syncope.admin.password"));
        SYNCOPE_ADDRESS = properties.getProperty("syncope.rest.services");
        String useGZIPCompression = properties.getProperty("useGZIPCompression");
        return new SyncopeClientFactoryBean().setAddress(SYNCOPE_ADDRESS).setUseCompression(BooleanUtils.toBoolean((String)useGZIPCompression)).create(properties.getProperty("syncope.admin.user"), syncopeAdminPassword);
    }

    public static <T> T get(Class<T> clazz) {
        LOG.debug("Creating service for {}", (Object)clazz.getName());
        return (T)SyncopeServices.client().getService(clazz);
    }

    public static BatchRequest batch() {
        return SyncopeServices.client().batch();
    }

    public static String getAddress() {
        return SYNCOPE_ADDRESS;
    }

    public static void testUsernameAndPassword(String username, String password) {
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(Paths.get(InstallConfigFileTemplate.configurationFilePath(), new String[0]), new OpenOption[0]);){
            properties.load(is);
        }
        catch (IOException e) {
            LOG.error("Error opening properties file", (Throwable)e);
        }
        SyncopeClient syncopeClient = new SyncopeClientFactoryBean().setAddress(properties.getProperty("syncope.rest.services")).create(username, password);
        ((SyncopeService)syncopeClient.getService(SyncopeService.class)).platform();
    }

    private SyncopeServices() {
    }
}

