/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.editors;

import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.syncope.common.lib.types.ReportTemplateFormat;
import org.apache.syncope.ide.eclipse.plugin.editors.HTMLEditor;
import org.apache.syncope.ide.eclipse.plugin.editors.TemplateEditorInput;
import org.apache.syncope.ide.eclipse.plugin.views.SyncopeView;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class TemplateEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    public static final String ID = "org.apache.syncope.ide.eclipse.plugin.editors.TemplateEditor";
    private static final String SAVE_TEMPLATE_LABEL = "Saving Template";
    private static final String ERROR_NESTED_EDITOR = "Error creating nested text editor";
    private static final String ERROR_INCORRECT_INPUT = "Wrong Input";
    private TextEditor editor;
    private TemplateEditorInput input;
    private String[] inputStringList;
    private String[] titleList;
    private String[] tooltipList;

    void createPage(String inputString, String title, String tooltip) {
        try {
            this.editor = title.equals("HTML") ? new HTMLEditor() : new StructuredTextEditor();
            int index = this.addPage((IEditorPart)this.editor, (IEditorInput)new TemplateEditorInput(inputString, title, tooltip));
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)ERROR_NESTED_EDITOR, null, (IStatus)e.getStatus());
        }
    }

    protected void createPages() {
        int i = 0;
        while (i < this.inputStringList.length) {
            this.createPage(this.inputStringList[i], this.titleList[i], this.tooltipList[i]);
            ++i;
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(final IProgressMonitor monitor) {
        final ITextEditor ite = (ITextEditor)this.getActiveEditor();
        final String content = ite.getDocumentProvider().getDocument((Object)ite.getEditorInput()).get();
        Job saveJob = new Job(SAVE_TEMPLATE_LABEL){

            protected IStatus run(IProgressMonitor arg0) {
                block14: {
                    block13: {
                        try {
                            if (ite.getTitle().equals("HTML")) {
                                SyncopeView.setMailTemplateContent(ite.getTitleToolTip(), MailTemplateFormat.HTML, content);
                                break block13;
                            }
                            if (ite.getTitle().equals("TEXT")) {
                                SyncopeView.setMailTemplateContent(ite.getTitleToolTip(), MailTemplateFormat.TEXT, content);
                                break block13;
                            }
                            if (ite.getTitle().equals("CSV")) {
                                SyncopeView.setReportTemplateContent(ite.getTitleToolTip(), ReportTemplateFormat.CSV, content);
                                break block13;
                            }
                            if (ite.getTitle().equals("XSL-FO")) {
                                SyncopeView.setReportTemplateContent(ite.getTitleToolTip(), ReportTemplateFormat.FO, content);
                                break block13;
                            }
                            if (ite.getTitle().equals("XSL-HTML")) {
                                SyncopeView.setReportTemplateContent(ite.getTitleToolTip(), ReportTemplateFormat.HTML, content);
                                break block13;
                            }
                            throw new Exception("Not a valid editor title");
                        }
                        catch (SyncopeClientException e) {
                            e.printStackTrace();
                            if (ClientExceptionType.NotFound.equals((Object)e.getType())) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TemplateEditor.this.getSite().getPage().closeEditor((IEditorPart)TemplateEditor.this, false);
                                    }
                                });
                                Status status = new Status(4, "org.apache.syncope.ide.eclipse.plugin", "Template No longer exists");
                                Display.getDefault().syncExec(new Runnable(ite, monitor){
                                    private final /* synthetic */ ITextEditor val$ite;
                                    private final /* synthetic */ IProgressMonitor val$monitor;
                                    {
                                        this.val$ite = iTextEditor;
                                        this.val$monitor = iProgressMonitor;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$ite.doSave(this.val$monitor);
                                    }
                                });
                                return status;
                            }
                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                            break block14;
                        }
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                            break block14;
                        }
                    }
                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        saveJob.setUser(true);
        saveJob.schedule();
    }

    public void doSaveAs() {
        this.getActiveEditor().doSaveAs();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof TemplateEditorInput)) {
            throw new RuntimeException(ERROR_INCORRECT_INPUT);
        }
        this.input = (TemplateEditorInput)editorInput;
        this.inputStringList = this.input.getInputStringList();
        this.titleList = this.input.getTitleList();
        this.tooltipList = this.input.getTooltipList();
        this.setSite((IWorkbenchPartSite)site);
        this.setInput((IEditorInput)this.input);
        this.setPartName(this.tooltipList[0]);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public ITextEditor getActiveHTMLEditor() {
        ITextEditor ite = (ITextEditor)this.getActiveEditor();
        if (ite.getTitle().equals("HTML")) {
            return (ITextEditor)this.getActiveEditor();
        }
        return null;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = TemplateEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)TemplateEditor.this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(TemplateEditor.this.editor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }
}

