/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDeleteByAttribute
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserDeleteByAttribute.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SEARCH_HELP_MESSAGE = "user --delete-by-attribute {REALM} {ATTR-NAME}={ATTR-VALUE}";
    private final Input input;

    public UserDeleteByAttribute(Input input) {
        this.input = input;
    }

    public void delete() {
        block7: {
            if (this.input.parameterNumber() == 2) {
                String realm = this.input.firstParameter();
                Pair<String, String> pairParameter = Input.toPairParameter(this.input.secondParameter());
                try {
                    if (!this.realmSyncopeOperations.exists(realm)) {
                        this.userResultManager.notFoundError("Realm", realm);
                        return;
                    }
                    List<BatchResponseItem> results = this.userSyncopeOperations.deleteByAttribute(realm, (String)pairParameter.getKey(), (String)pairParameter.getValue());
                    HashMap<String, String> failedUsers = new HashMap<String, String>();
                    AtomicReference<Integer> deletedUsers = new AtomicReference<Integer>(0);
                    results.forEach(item -> {
                        if (item.getStatus() == Response.Status.OK.getStatusCode()) {
                            deletedUsers.getAndSet((Integer)deletedUsers.get() + 1);
                        } else {
                            try {
                                ProvisioningResult user = (ProvisioningResult)MAPPER.readValue(item.getContent(), (TypeReference)new TypeReference<ProvisioningResult<UserTO>>(){});
                                failedUsers.put(((UserTO)user.getEntity()).getUsername(), ((List)item.getHeaders().get("X-Application-Error-Code")).toString());
                            }
                            catch (IOException ioe) {
                                LOG.error("Error reading {}", (Object)item.getContent(), (Object)ioe);
                            }
                        }
                    });
                    this.userResultManager.genericMessage("Deleted users: " + deletedUsers);
                    if (!failedUsers.isEmpty()) {
                        this.userResultManager.printFailedUsers(failedUsers);
                    }
                }
                catch (Exception e) {
                    LOG.error("Error searching user", (Throwable)e);
                    if (e.getMessage().startsWith("NotFound")) {
                        this.userResultManager.notFoundError("User with " + (String)pairParameter.getKey(), (String)pairParameter.getValue());
                        break block7;
                    }
                    this.userResultManager.genericError(e.getMessage());
                }
            } else {
                this.userResultManager.commandOptionError(SEARCH_HELP_MESSAGE);
            }
        }
    }
}

