/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.TaskTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDeleteAllProp
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDeleteAllProp.class);
    private static final String DELETE_HELP_MESSAGE = "task --delete-all-prop";
    private final Input input;

    public TaskDeleteAllProp(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() == 0) {
            for (TaskTO taskTO : this.taskSyncopeOperations.listPropagationTask()) {
                String taskId = String.valueOf(taskTO.getKey());
                try {
                    this.taskSyncopeOperations.delete(taskId);
                    this.taskResultManager.deletedMessage("Task", taskId);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting task", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.taskResultManager.notFoundError("Task", taskId);
                        continue;
                    }
                    if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.taskResultManager.genericError("You cannot delete task " + taskId);
                        continue;
                    }
                    this.taskResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting task", (Throwable)ex);
                    this.taskResultManager.notBooleanDeletedError("task", taskId);
                }
            }
        } else {
            this.taskResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

