/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.util.Arrays;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.report.AbstractReportCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportExportExecution
extends AbstractReportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReportExportExecution.class);
    private static final String EXPORT_EXECUTION_HELP_MESSAGE = "report --export-execution-result {EXECUTION-KEY} {EXECUTION-KEY} [...] {FORMAT}\n          Format: CSV / HTML / PDF / XML / RTF";
    private final Input input;

    public ReportExportExecution(Input input) {
        this.input = input;
    }

    public void export() {
        block7: {
            if (this.input.parameterNumber() >= 2) {
                int n = 0;
                String[] parameters = Arrays.copyOf(this.input.getParameters(), this.input.parameterNumber() - 1);
                String[] stringArray = parameters;
                int n2 = stringArray.length;
                if (n < n2) {
                    String parameter = stringArray[n];
                    try {
                        String result = this.reportSyncopeOperations.exportExecutionResult(parameter, this.input.lastParameter());
                        this.reportResultManager.genericMessage(result + "created.");
                    }
                    catch (WebServiceException | SyncopeClientException e) {
                        LOG.error("Error exporting execution", e);
                        if (e.getMessage().startsWith("NotFound")) {
                            this.reportResultManager.notFoundError("Report", parameter);
                            break block7;
                        }
                        this.reportResultManager.genericError(e.getMessage());
                    }
                    catch (Exception e) {
                        LOG.error("Error exporting execution", (Throwable)e);
                        this.reportResultManager.genericError(" - Error creating export_" + parameter + " " + e.getMessage());
                    }
                }
            } else {
                this.reportResultManager.commandOptionError(EXPORT_EXECUTION_HELP_MESSAGE);
            }
        }
    }
}

