/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.question;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.question.AbstractQuestionCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionDelete
extends AbstractQuestionCommand {
    private static final Logger LOG = LoggerFactory.getLogger(QuestionDelete.class);
    private static final String DELETE_HELP_MESSAGE = "question --delete {QUESTION-KEY} {QUESTION-KEY} [...]";
    private final Input input;

    public QuestionDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.getParameters().length >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.questionSyncopeOperations.delete(parameter);
                    this.questionResultManager.deletedMessage("security question", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting question", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.questionResultManager.notFoundError("Security question", parameter);
                    } else {
                        this.questionResultManager.genericError(ex.getMessage());
                    }
                    break;
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting question", (Throwable)ex);
                    this.questionResultManager.numberFormatException("security question", parameter);
                }
            }
        } else {
            this.questionResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

