/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.policy;

import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.common.lib.policy.AccountPolicyTO;
import org.apache.syncope.common.lib.policy.PasswordPolicyTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.PullPolicyTO;
import org.apache.syncope.common.lib.types.PolicyType;

public class PolicyResultManager
extends CommonsResultManager {
    public void printPolicies(List<PolicyTO> policyTOs) {
        System.out.println("");
        policyTOs.forEach(policyTO -> {
            if (policyTO instanceof AccountPolicyTO) {
                this.printAccountPolicy((AccountPolicyTO)policyTO);
            } else if (policyTO instanceof PasswordPolicyTO) {
                this.printPasswordPolicy((PasswordPolicyTO)policyTO);
            } else if (policyTO instanceof PullPolicyTO) {
                this.printPullPolicy((PullPolicyTO)policyTO);
            }
        });
    }

    public void printPoliciesByType(String policyTypeString, List<PolicyTO> policyTOs) {
        System.out.println("");
        PolicyType policyType = PolicyType.valueOf((String)policyTypeString);
        switch (policyType) {
            case ACCOUNT: {
                policyTOs.forEach(policyTO -> this.printAccountPolicy((AccountPolicyTO)policyTO));
                break;
            }
            case PASSWORD: {
                policyTOs.forEach(policyTO -> this.printPasswordPolicy((PasswordPolicyTO)policyTO));
                break;
            }
            case PUSH: {
                policyTOs.forEach(policyTO -> System.out.println(policyTO));
                break;
            }
            case PULL: {
                policyTOs.forEach(policyTO -> this.printPullPolicy((PullPolicyTO)policyTO));
                break;
            }
        }
    }

    public void printAccountPolicy(AccountPolicyTO policyTO) {
        System.out.println(" > KEY: " + policyTO.getKey());
        System.out.println("    type: " + policyTO.getClass().getSimpleName());
        System.out.println("    description: " + policyTO.getDescription());
        System.out.println("    resources : " + policyTO.getUsedByResources().toString());
        System.out.println("    realms : " + policyTO.getUsedByRealms().toString());
        System.out.println("    max authentication attempts : " + policyTO.getMaxAuthenticationAttempts());
        System.out.println("    propagation suspension : " + policyTO.isPropagateSuspension());
        System.out.println("    RULES : ");
        System.out.println("       > class : " + policyTO.getRules());
        System.out.println("");
    }

    public void printPasswordPolicy(PasswordPolicyTO policyTO) {
        System.out.println(" > KEY: " + policyTO.getKey());
        System.out.println("    type: " + policyTO.getClass().getSimpleName());
        System.out.println("    description: " + policyTO.getDescription());
        System.out.println("    resources : " + policyTO.getUsedByResources().toString());
        System.out.println("    realms : " + policyTO.getUsedByRealms().toString());
        System.out.println("    history lenght : " + policyTO.getHistoryLength());
        System.out.println("    allow null password : " + policyTO.isAllowNullPassword());
        System.out.println("    RULES : ");
        System.out.println("       > class : " + policyTO.getRules());
        System.out.println("");
    }

    public void printPullPolicy(PullPolicyTO policyTO) {
        System.out.println(" > KEY: " + policyTO.getKey());
        System.out.println("    type: " + policyTO.getClass().getSimpleName());
        System.out.println("    description: " + policyTO.getDescription());
        System.out.println("    resources : " + policyTO.getUsedByResources().toString());
        System.out.println("    realms : " + policyTO.getUsedByRealms().toString());
        System.out.println("    conflict resolution action: " + policyTO.getConflictResolutionAction().name());
        System.out.println("    correlation rules : " + policyTO.getCorrelationRules().toString());
        System.out.println("");
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("policies details", details);
    }
}

