/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.notification;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.notification.NotificationDelete;
import org.apache.syncope.client.cli.commands.notification.NotificationList;
import org.apache.syncope.client.cli.commands.notification.NotificationRead;
import org.apache.syncope.client.cli.commands.notification.NotificationResultManager;

@Command(name="notification")
public class NotificationCommand
extends AbstractCommand {
    private final NotificationResultManager notificationResultManager = new NotificationResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(Options.HELP.getOptionName());
        }
        switch (Options.fromName(input.getOption())) {
            case LIST: {
                new NotificationList(input).list();
                break;
            }
            case READ: {
                new NotificationRead(input).read();
                break;
            }
            case DELETE: {
                new NotificationDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.notificationResultManager.deletedMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.notificationResultManager.commandHelpMessage(this.getClass());
    }

    private static enum Options {
        HELP("--help"),
        LIST("--list"),
        READ("--read"),
        DELETE("--delete");

        private final String optionName;

        private Options(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static Options fromName(String name) {
            Options optionToReturn = HELP;
            for (Options option : Options.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (Options value : Options.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

