/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.install;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import javax.ws.rs.ProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.client.cli.commands.install.InstallConfigFileTemplate;
import org.apache.syncope.client.cli.commands.install.InstallResultManager;
import org.apache.syncope.client.cli.util.FileSystemUtils;
import org.apache.syncope.client.cli.util.JasyptUtils;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallSetup {
    private static final Logger LOG = LoggerFactory.getLogger(InstallSetup.class);
    private final InstallResultManager installResultManager = new InstallResultManager();
    private String syncopeAdminUser;
    private String syncopeAdminPassword;
    private String syncopeServerSchema;
    private String syncopeServerHostname = "localhost";
    private String syncopeServerPort = "8080";
    private String syncopeServerRestContext = "/syncope/rest/";

    public void setup() throws FileNotFoundException, IllegalAccessException {
        this.installResultManager.printWelcome();
        System.out.println("Path to config files of Syncope CLI client will be: " + InstallConfigFileTemplate.dirPath());
        if (!FileSystemUtils.exists(InstallConfigFileTemplate.dirPath())) {
            throw new FileNotFoundException("Directory: " + InstallConfigFileTemplate.dirPath() + " does not exists!");
        }
        if (!FileSystemUtils.canWrite(InstallConfigFileTemplate.dirPath())) {
            throw new IllegalAccessException("Permission denied on " + InstallConfigFileTemplate.dirPath());
        }
        System.out.println("- File system permission checked");
        System.out.println("");
        try (Scanner scanIn = new Scanner(System.in);){
            System.out.print("Syncope server schema [http/https]: ");
            String syncopeServerSchemaFromSystemIn = scanIn.nextLine();
            boolean schemaFound = false;
            while (!schemaFound) {
                if ("http".equalsIgnoreCase(syncopeServerSchemaFromSystemIn) || "https".equalsIgnoreCase(syncopeServerSchemaFromSystemIn)) {
                    this.syncopeServerSchema = syncopeServerSchemaFromSystemIn;
                    schemaFound = true;
                    continue;
                }
                System.out.println("Please use one of below values: ");
                System.out.println("   - http");
                System.out.println("   - https");
                syncopeServerSchemaFromSystemIn = scanIn.nextLine();
            }
            System.out.print("Syncope server hostname [e.g. " + this.syncopeServerHostname + "]: ");
            String syncopeServerHostnameFromSystemIn = scanIn.nextLine();
            boolean syncopeServerHostnameFound = false;
            while (!syncopeServerHostnameFound) {
                if (StringUtils.isNotBlank((CharSequence)syncopeServerHostnameFromSystemIn)) {
                    this.syncopeServerHostname = syncopeServerHostnameFromSystemIn;
                    syncopeServerHostnameFound = true;
                    continue;
                }
                System.out.print("Syncope server hostname [e.g. " + this.syncopeServerHostname + "]: ");
                syncopeServerHostnameFromSystemIn = scanIn.nextLine();
            }
            System.out.print("Syncope server port [e.g. " + this.syncopeServerPort + "]: ");
            String syncopeServerPortFromSystemIn = scanIn.nextLine();
            boolean syncopeServerPortFound = false;
            while (!syncopeServerPortFound) {
                if (StringUtils.isNotBlank((CharSequence)syncopeServerPortFromSystemIn)) {
                    this.syncopeServerPort = syncopeServerPortFromSystemIn;
                    syncopeServerPortFound = true;
                    continue;
                }
                if (!StringUtils.isNumeric((CharSequence)syncopeServerPortFromSystemIn)) {
                    System.err.println(syncopeServerPortFromSystemIn + " is not a numeric string, try again");
                    syncopeServerPortFromSystemIn = scanIn.nextLine();
                    continue;
                }
                System.out.print("Syncope server port [e.g. " + this.syncopeServerPort + "]: ");
                syncopeServerPortFromSystemIn = scanIn.nextLine();
            }
            System.out.print("Syncope server rest context [e.g. " + this.syncopeServerRestContext + "]: ");
            String syncopeServerRestContextFromSystemIn = scanIn.nextLine();
            boolean syncopeServerRestContextFound = false;
            while (!syncopeServerRestContextFound) {
                if (StringUtils.isNotBlank((CharSequence)syncopeServerRestContextFromSystemIn)) {
                    this.syncopeServerRestContext = syncopeServerRestContextFromSystemIn;
                    syncopeServerRestContextFound = true;
                    continue;
                }
                System.out.print("Syncope server port [e.g. " + this.syncopeServerRestContext + "]: ");
                syncopeServerRestContextFromSystemIn = scanIn.nextLine();
            }
            System.out.print("Syncope admin user: ");
            String syncopeAdminUserFromSystemIn = scanIn.nextLine();
            boolean syncopeAdminUserFound = false;
            while (!syncopeAdminUserFound) {
                if (StringUtils.isNotBlank((CharSequence)syncopeAdminUserFromSystemIn)) {
                    this.syncopeAdminUser = syncopeAdminUserFromSystemIn;
                    syncopeAdminUserFound = true;
                    continue;
                }
                System.out.print("Syncope admin user: ");
                syncopeAdminUserFromSystemIn = scanIn.nextLine();
            }
            char[] syncopeAdminPasswordFromSystemConsole = System.console().readPassword("Syncope admin password: ", new Object[0]);
            boolean syncopeAdminPasswordFound = false;
            while (!syncopeAdminPasswordFound) {
                if (syncopeAdminPasswordFromSystemConsole != null && syncopeAdminPasswordFromSystemConsole.length > 0) {
                    this.syncopeAdminPassword = new String(syncopeAdminPasswordFromSystemConsole);
                    syncopeAdminPasswordFound = true;
                    continue;
                }
                syncopeAdminPasswordFromSystemConsole = System.console().readPassword("Syncope admin password: ", new Object[0]);
            }
        }
        JasyptUtils jasyptUtils = JasyptUtils.get();
        try {
            String contentCliPropertiesFile = InstallConfigFileTemplate.cliPropertiesFile(this.syncopeServerSchema, this.syncopeServerHostname, this.syncopeServerPort, this.syncopeServerRestContext, this.syncopeAdminUser, jasyptUtils.encrypt(this.syncopeAdminPassword));
            FileSystemUtils.createFileWith(InstallConfigFileTemplate.configurationFilePath(), contentCliPropertiesFile);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        try {
            SyncopeService syncopeService = SyncopeServices.get(SyncopeService.class);
            String syncopeVersion = syncopeService.platform().getVersion();
            this.installResultManager.installationSuccessful(syncopeVersion);
        }
        catch (ProcessingException ex) {
            LOG.error("Error installing CLI", (Throwable)ex);
            this.installResultManager.manageProcessingException(ex);
        }
        catch (Exception e) {
            LOG.error("Error installing CLI", (Throwable)e);
            this.installResultManager.manageException(e);
        }
    }
}

