/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.install;

import java.util.ResourceBundle;
import org.apache.commons.lang3.SystemUtils;

public final class InstallConfigFileTemplate {
    private static final ResourceBundle CONF = ResourceBundle.getBundle("configuration");
    public static final String CONFIGURATION_FILE_NAME = CONF.getString("cli.installation.filename");
    private static final String SYNCOPE_REST_SERVICES = "syncope.rest.services=%s://%s:%s%s";
    private static final String SYNCOPE_ADMIN_USER = "syncope.admin.user=%s";
    private static final String SYNCOPE_ADMIN_PASSWORD = "syncope.admin.password=%s";

    public static String cliPropertiesFile(String schema, String hostname, String port, String restContext, String user, String password) {
        String syncopeRestServices = String.format(SYNCOPE_REST_SERVICES, schema, hostname, port, restContext);
        String syncopeAdminUser = String.format(SYNCOPE_ADMIN_USER, user);
        String syncopeAdminPassword = String.format(SYNCOPE_ADMIN_PASSWORD, password);
        String useGZIPCompression = String.format("syncope.useGZIPCompression=true", new Object[0]);
        return syncopeRestServices + "\n" + syncopeAdminUser + "\n" + syncopeAdminPassword + "\n" + useGZIPCompression;
    }

    public static String dirPath() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return CONF.getString("cli.installation.directory.windows");
        }
        return CONF.getString("cli.installation.directory.linux");
    }

    public static String configurationFilePath() {
        return InstallConfigFileTemplate.dirPath() + CONFIGURATION_FILE_NAME;
    }

    private static String scriptFileName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return CONF.getString("script.file.name.windows");
        }
        return CONF.getString("script.file.name.linux");
    }

    public static String scriptFilePath() {
        return InstallConfigFileTemplate.dirPath() + InstallConfigFileTemplate.scriptFileName();
    }

    private InstallConfigFileTemplate() {
    }
}

