/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.connector;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.connector.ConnectorDelete;
import org.apache.syncope.client.cli.commands.connector.ConnectorDetails;
import org.apache.syncope.client.cli.commands.connector.ConnectorList;
import org.apache.syncope.client.cli.commands.connector.ConnectorListBundles;
import org.apache.syncope.client.cli.commands.connector.ConnectorListConfigurationProperties;
import org.apache.syncope.client.cli.commands.connector.ConnectorRead;
import org.apache.syncope.client.cli.commands.connector.ConnectorReadByResource;
import org.apache.syncope.client.cli.commands.connector.ConnectorResultManager;

@Command(name="connector")
public class ConnectorCommand
extends AbstractCommand {
    private final ConnectorResultManager connectorResultManager = new ConnectorResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(ConnectorOptions.HELP.getOptionName());
        }
        switch (ConnectorOptions.fromName(input.getOption())) {
            case DETAILS: {
                new ConnectorDetails(input).details();
                break;
            }
            case LIST: {
                new ConnectorList(input).list();
                break;
            }
            case LIST_BUNDLES: {
                new ConnectorListBundles(input).list();
                break;
            }
            case LIST_CONFIGURATION: {
                new ConnectorListConfigurationProperties(input).list();
                break;
            }
            case READ: {
                new ConnectorRead(input).read();
                break;
            }
            case READ_BY_RESOURCE: {
                new ConnectorReadByResource(input).read();
                break;
            }
            case DELETE: {
                new ConnectorDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.connectorResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.connectorResultManager.commandHelpMessage(this.getClass());
    }

    public static enum ConnectorOptions {
        HELP("--help"),
        LIST("--list"),
        DETAILS("--details"),
        LIST_BUNDLES("--list-bundles"),
        LIST_CONFIGURATION("--list-configuration-properties"),
        READ("--read"),
        READ_BY_RESOURCE("--read-by-resource"),
        DELETE("--delete");

        private final String optionName;

        private ConnectorOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static ConnectorOptions fromName(String name) {
            ConnectorOptions optionToReturn = HELP;
            for (ConnectorOptions option : ConnectorOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (ConnectorOptions value : ConnectorOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

