/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.anyobject;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.anyobject.AbstractAnyObjectCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyObjectRead
extends AbstractAnyObjectCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AnyObjectRead.class);
    private static final String READ_HELP_MESSAGE = "any --read {ANY_OBJECT-KEY} {ANY_OBJECT-KEY} [...]";
    private final Input input;

    public AnyObjectRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.anyResultManager.printAny(this.anySyncopeOperations.read(parameter));
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error reading group", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.anyResultManager.notFoundError("Any object", parameter);
                        continue;
                    }
                    this.anyResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    this.anyResultManager.numberFormatException("any object", parameter);
                }
            }
        } else {
            this.anyResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

