/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.ReportTemplateTO;
import org.apache.syncope.common.lib.types.ReportTemplateFormat;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="ReportTemplates")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="reportTemplates")
public interface ReportTemplateService
extends JAXRSService {
    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<ReportTemplateTO> list();

    @ApiResponses(value={@ApiResponse(responseCode="201", description="ReportTemplate successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="Key value for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull ReportTemplateTO var1);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ReportTemplateTO read(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @GET
    @Path(value="{key}/{format}")
    public Response getFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") ReportTemplateFormat var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{key}/{format}")
    public void setFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") ReportTemplateFormat var2, InputStream var3);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}/{format}")
    public void removeFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") ReportTemplateFormat var2);
}

