/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp.ha;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactory;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactoryManager;
import org.apache.synapse.transport.amqp.ha.AMQPTransportHABrokerEntry;
import org.apache.synapse.transport.amqp.ha.AMQPTransportHAEntry;

public class AMQPTransportReconnectHandler
implements Runnable {
    private BlockingQueue<AMQPTransportHAEntry> blockedTasks = new LinkedBlockingQueue<AMQPTransportHAEntry>();
    private ConcurrentMap<String, AMQPTransportHABrokerEntry> connectionMap = new ConcurrentHashMap<String, AMQPTransportHABrokerEntry>();
    private AMQPTransportConnectionFactoryManager connectionFactoryManager;
    private int initialReconnectDuration = 1000;
    private double reconnectionProgressionFactor = 2.0;
    private int maxReconnectionDuration = 600000;
    private ExecutorService es;
    private static Log log = LogFactory.getLog(AMQPTransportReconnectHandler.class);

    public AMQPTransportReconnectHandler(ExecutorService es, int maxReconnectionDuration, double reconnectionProgressionFactor, int initialReconnectDuration, AMQPTransportConnectionFactoryManager connectionFactoryManager) {
        this.es = es;
        this.maxReconnectionDuration = maxReconnectionDuration;
        this.reconnectionProgressionFactor = reconnectionProgressionFactor;
        this.initialReconnectDuration = initialReconnectDuration;
        this.connectionFactoryManager = connectionFactoryManager;
    }

    @Override
    public void run() {
        try {
            AMQPTransportHAEntry entry = this.blockedTasks.take();
            if (entry != null) {
                Map<String, String> params = this.connectionFactoryManager.getConnectionFactory(entry.getConnectionFactoryName()).getParameters();
                int count = 1;
                long retryDuration = this.initialReconnectDuration;
                while (true) {
                    try {
                        Thread.sleep(this.initialReconnectDuration);
                        new AMQPTransportConnectionFactory(params, this.es);
                        log.info((Object)("The reconnection attempt '" + count + "' was successful"));
                    }
                    catch (AMQPTransportException e) {
                        retryDuration = (long)((double)retryDuration * this.reconnectionProgressionFactor);
                        if (retryDuration > (long)this.maxReconnectionDuration) {
                            retryDuration = this.initialReconnectDuration;
                            log.info((Object)("The retry duration exceeded the maximum reconnection duration. The retry duration is set to initial reconnection duration value(" + this.initialReconnectDuration + "s)"));
                        }
                        log.info((Object)("The reconnection attempt number '" + count++ + "' failed. Next re-try will be after '" + retryDuration / 1000L + "' seconds"));
                        try {
                            Thread.sleep(retryDuration);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
                ConcurrentHashMap<String, AMQPTransportConnectionFactory> allFac = this.connectionFactoryManager.getAllFactories();
                for (Map.Entry<String, AMQPTransportConnectionFactory> me : allFac.entrySet()) {
                    String name = me.getKey();
                    Map<String, String> param = me.getValue().getParameters();
                    this.connectionFactoryManager.removeConnectionFactory(name);
                    this.connectionFactoryManager.addConnectionFactory(name, new AMQPTransportConnectionFactory(param, this.es));
                    log.info((Object)("A new connection factory was created for -> '" + name + "'"));
                }
                String conFacName = entry.getConnectionFactoryName();
                AMQPTransportConnectionFactory cf = this.connectionFactoryManager.getConnectionFactory(conFacName);
                this.connectionMap.put(entry.getKey(), new AMQPTransportHABrokerEntry(cf.getChannel(), cf.getConnection()));
                entry.getLock().release();
                while (!this.blockedTasks.isEmpty()) {
                    entry = this.blockedTasks.take();
                    conFacName = entry.getConnectionFactoryName();
                    cf = this.connectionFactoryManager.getConnectionFactory(conFacName);
                    this.connectionMap.put(entry.getKey(), new AMQPTransportHABrokerEntry(cf.getChannel(), cf.getConnection()));
                    if (log.isDebugEnabled()) {
                        log.info((Object)("The worker task with key '" + entry.getKey() + "' was combined with a new connection factory"));
                    }
                    entry.getLock().release();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (AMQPTransportException e) {
            log.error((Object)"High Availability handler just died!. It's time to reboot the system.", (Throwable)e);
        }
    }

    public BlockingQueue<AMQPTransportHAEntry> getBlockedTasks() {
        return this.blockedTasks;
    }

    public ConcurrentMap<String, AMQPTransportHABrokerEntry> getConnectionMap() {
        return this.connectionMap;
    }
}

