/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.gson;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.gson.GsonXMLStreamWriter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(JsonFormatter.class);

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat omOutputFormat) throws AxisFault {
        return new byte[0];
    }

    public void writeTo(MessageContext outMsgCtxt, OMOutputFormat omOutputFormat, OutputStream outputStream, boolean b) throws AxisFault {
        block13: {
            String charSetEncoding = (String)outMsgCtxt.getProperty("CHARACTER_SET_ENCODING");
            try {
                JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter(outputStream, charSetEncoding));
                Object retObj = outMsgCtxt.getProperty("returnObject");
                if (outMsgCtxt.isProcessingFault()) {
                    OMElement element = outMsgCtxt.getEnvelope().getBody().getFirstElement();
                    try {
                        jsonWriter.beginObject();
                        jsonWriter.name(element.getLocalName());
                        jsonWriter.beginObject();
                        Iterator childrenIterator = element.getChildElements();
                        while (childrenIterator.hasNext()) {
                            Object next = childrenIterator.next();
                            OMElement omElement = (OMElement)next;
                            jsonWriter.name(omElement.getLocalName());
                            jsonWriter.value(omElement.getText());
                        }
                        jsonWriter.endObject();
                        jsonWriter.endObject();
                        jsonWriter.flush();
                        jsonWriter.close();
                        break block13;
                    }
                    catch (IOException e) {
                        throw new AxisFault("Error while processing fault code in JsonWriter");
                    }
                }
                if (retObj == null) {
                    OMElement element = outMsgCtxt.getEnvelope().getBody().getFirstElement();
                    QName elementQname = outMsgCtxt.getAxisOperation().getMessage("Out").getElementQName();
                    ArrayList schemas = outMsgCtxt.getAxisService().getSchema();
                    GsonXMLStreamWriter xmlsw = new GsonXMLStreamWriter(jsonWriter, elementQname, schemas, outMsgCtxt.getConfigurationContext());
                    try {
                        xmlsw.writeStartDocument();
                        if (b) {
                            element.serialize((XMLStreamWriter)xmlsw);
                        } else {
                            element.serializeAndConsume((XMLStreamWriter)xmlsw);
                        }
                        xmlsw.writeEndDocument();
                        break block13;
                    }
                    catch (XMLStreamException e) {
                        throw new AxisFault("Error while writing to the output stream using JsonWriter", (Throwable)e);
                    }
                }
                try {
                    Gson gson = new Gson();
                    jsonWriter.beginObject();
                    jsonWriter.name("response");
                    Type returnType = (Type)outMsgCtxt.getProperty("returnType");
                    gson.toJson(retObj, returnType, jsonWriter);
                    jsonWriter.endObject();
                    jsonWriter.flush();
                }
                catch (IOException e) {
                    String msg = "Exception occur while writting to JsonWriter at the JsonFormatter ";
                    log.error((Object)msg, (Throwable)e);
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
            catch (UnsupportedEncodingException e) {
                String msg = "Exception occur when try to encode output stream usig  CHARACTER_SET_ENCODING charset";
                log.error((Object)msg, (Throwable)e);
                throw AxisFault.makeFault((Throwable)e);
            }
        }
    }

    public String getContentType(MessageContext outMsgCtxt, OMOutputFormat omOutputFormat, String s) {
        return (String)outMsgCtxt.getProperty("ContentType");
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat omOutputFormat, URL url) throws AxisFault {
        return null;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat omOutputFormat, String s) {
        return null;
    }
}

