/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import javax.activation.DataHandler;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisServiceGroup;

public class ClusteringUtils {
    private static final Random RANDOM = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadServiceGroup(String serviceGroupName, ConfigurationContext configCtx, String tempDirectory) throws Exception {
        File serviceArchive;
        String axis2Repo;
        if (!serviceGroupName.endsWith(".aar")) {
            serviceGroupName = serviceGroupName + ".aar";
        }
        if (ClusteringUtils.isURL(axis2Repo = System.getProperty("axis2.repo"))) {
            DataHandler dh = new DataHandler(new URL(axis2Repo + "services/" + serviceGroupName));
            String tempDirName = tempDirectory + File.separator + ((double)System.currentTimeMillis() + RANDOM.nextDouble());
            if (!new File(tempDirName).mkdirs()) {
                throw new Exception("Could not create temp dir " + tempDirName);
            }
            serviceArchive = new File(tempDirName + File.separator + serviceGroupName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(serviceArchive);
                dh.writeTo((OutputStream)out);
                out.close();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        } else {
            serviceArchive = new File(axis2Repo + File.separator + "services" + File.separator + serviceGroupName);
        }
        if (!serviceArchive.exists()) {
            throw new FileNotFoundException("File " + serviceArchive + " not found");
        }
        AxisServiceGroup asGroup = DeploymentEngine.loadServiceGroup((File)serviceArchive, (ConfigurationContext)configCtx);
        configCtx.getAxisConfiguration().addServiceGroup(asGroup);
    }

    private static boolean isURL(String location) {
        try {
            new URL(location);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

