/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import quickfix.ConfigError;
import quickfix.Field;
import quickfix.FieldConvertError;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.Group;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SocketAcceptor;

public class FIXUtils {
    private static final Log log = LogFactory.getLog(FIXUtils.class);
    private static FIXUtils _instance = new FIXUtils();

    public static FIXUtils getInstance() {
        return _instance;
    }

    public void setSOAPEnvelope(Message message, int counter, String sessionID, MessageContext msgCtx) throws AxisFault {
        String binaryCID;
        OMElement binaryData;
        String contentID;
        DataHandler dataHandler;
        ByteArrayDataSource dataSource;
        Object value;
        OMElement msgField;
        Field field;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating SOAP envelope for FIX message...");
        }
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        OMElement msg = soapFactory.createOMElement("message", null);
        msg.addAttribute(soapFactory.createOMAttribute("inSession", null, sessionID));
        msg.addAttribute(soapFactory.createOMAttribute("counter", null, String.valueOf(counter)));
        OMElement header = soapFactory.createOMElement("header", null);
        OMElement body = soapFactory.createOMElement("body", null);
        OMElement trailer = soapFactory.createOMElement("trailer", null);
        Iterator iter = message.getHeader().iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                field = (Field)iter.next();
                msgField = soapFactory.createOMElement("field", null);
                msgField.addAttribute(soapFactory.createOMAttribute("id", null, String.valueOf(field.getTag())));
                value = field.getObject();
                if (value instanceof byte[]) {
                    dataSource = new ByteArrayDataSource((byte[])value);
                    dataHandler = new DataHandler((DataSource)dataSource);
                    contentID = msgCtx.addAttachment(dataHandler);
                    binaryData = soapFactory.createOMElement("rawdata", null);
                    binaryCID = "cid:" + contentID;
                    binaryData.addAttribute("href", binaryCID, null);
                    msgField.addChild((OMNode)binaryData);
                } else {
                    FIXUtils.createOMText(soapFactory, msgField, value.toString());
                }
                header.addChild((OMNode)msgField);
            }
        }
        this.convertFIXBodyToXML((FieldMap)message, body, soapFactory, msgCtx);
        iter = message.getTrailer().iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                field = (Field)iter.next();
                msgField = soapFactory.createOMElement("field", null);
                msgField.addAttribute(soapFactory.createOMAttribute("id", null, String.valueOf(field.getTag())));
                value = field.getObject();
                if (value instanceof byte[]) {
                    dataSource = new ByteArrayDataSource((byte[])value);
                    dataHandler = new DataHandler((DataSource)dataSource);
                    contentID = msgCtx.addAttachment(dataHandler);
                    binaryData = soapFactory.createOMElement("rawdata", null);
                    binaryCID = "cid:" + contentID;
                    binaryData.addAttribute("href", binaryCID, null);
                    msgField.addChild((OMNode)binaryData);
                } else {
                    FIXUtils.createOMText(soapFactory, msgField, value.toString());
                }
                trailer.addChild((OMNode)msgField);
            }
        }
        msg.addChild((OMNode)header);
        msg.addChild((OMNode)body);
        msg.addChild((OMNode)trailer);
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)msg);
        msgCtx.setEnvelope(envelope);
    }

    private void convertFIXBodyToXML(FieldMap message, OMElement body, SOAPFactory soapFactory, MessageContext msgCtx) throws AxisFault {
        Iterator groupKeyItr;
        Iterator iter;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating FIX message body (Message ID: " + msgCtx.getMessageID() + ")"));
        }
        if ((iter = message.iterator()) != null) {
            while (iter.hasNext()) {
                Field field = (Field)iter.next();
                OMElement msgField = soapFactory.createOMElement("field", null);
                msgField.addAttribute(soapFactory.createOMAttribute("id", null, String.valueOf(field.getTag())));
                Object value = field.getObject();
                if (value instanceof byte[]) {
                    ByteArrayDataSource dataSource = new ByteArrayDataSource((byte[])value);
                    DataHandler dataHandler = new DataHandler((DataSource)dataSource);
                    String contentID = msgCtx.addAttachment(dataHandler);
                    OMElement binaryData = soapFactory.createOMElement("rawdata", null);
                    String binaryCID = "cid:" + contentID;
                    binaryData.addAttribute("href", binaryCID, null);
                    msgField.addChild((OMNode)binaryData);
                } else {
                    FIXUtils.createOMText(soapFactory, msgField, value.toString());
                }
                body.addChild((OMNode)msgField);
            }
        }
        if ((groupKeyItr = message.groupKeyIterator()) != null) {
            while (groupKeyItr.hasNext()) {
                int groupKey = (Integer)groupKeyItr.next();
                OMElement groupsField = soapFactory.createOMElement("groups", null);
                groupsField.addAttribute("id", String.valueOf(groupKey), null);
                List groupList = message.getGroups(groupKey);
                for (Group msgGroup : groupList) {
                    OMElement groupField = soapFactory.createOMElement("group", null);
                    this.convertFIXBodyToXML((FieldMap)msgGroup, groupField, soapFactory, msgCtx);
                    groupsField.addChild((OMNode)groupField);
                }
                body.addChild((OMNode)groupsField);
            }
        }
    }

    private void generateFIXBody(OMElement node, FieldMap message, MessageContext msgCtx, boolean withNs, String nsURI, String nsPrefix) throws IOException {
        Iterator bodyElements = node.getChildElements();
        while (bodyElements.hasNext()) {
            OMElement bodyNode = (OMElement)bodyElements.next();
            String nodeLocalName = bodyNode.getLocalName();
            if (nodeLocalName.equals("groups")) {
                int groupsKey = Integer.parseInt(bodyNode.getAttributeValue(new QName("id")));
                Iterator groupElements = bodyNode.getChildElements();
                while (groupElements.hasNext()) {
                    OMElement groupNode = (OMElement)groupElements.next();
                    Iterator groupFields = groupNode.getChildrenWithName(new QName("field"));
                    ArrayList<Integer> idList = new ArrayList<Integer>();
                    while (groupFields.hasNext()) {
                        OMElement fieldNode = (OMElement)groupFields.next();
                        idList.add(Integer.parseInt(fieldNode.getAttributeValue(new QName("id"))));
                    }
                    int[] order = new int[idList.size()];
                    for (int i = 0; i < order.length; ++i) {
                        order[i] = (Integer)idList.get(i);
                    }
                    Group group = new Group(groupsKey, order[0], order);
                    this.generateFIXBody(groupNode, (FieldMap)group, msgCtx, withNs, nsURI, nsPrefix);
                    message.addGroup(group);
                }
                continue;
            }
            String tag = withNs ? bodyNode.getAttributeValue(new QName(nsURI, "id", nsPrefix)) : bodyNode.getAttributeValue(new QName("id"));
            String value = null;
            OMElement child = bodyNode.getFirstElement();
            if (child != null) {
                String href = withNs ? bodyNode.getFirstElement().getAttributeValue(new QName(nsURI, "id", nsPrefix)) : bodyNode.getFirstElement().getAttributeValue(new QName("href"));
                if (href != null) {
                    DataHandler binaryDataHandler = msgCtx.getAttachment(href.substring(4));
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    binaryDataHandler.writeTo((OutputStream)outputStream);
                    value = new String(outputStream.toByteArray());
                }
            } else {
                value = bodyNode.getText();
            }
            if (value == null) continue;
            message.setString(Integer.parseInt(tag), value);
        }
    }

    public Message createFIXMessage(MessageContext msgCtx) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting FIX message from the message context (Message ID: " + msgCtx.getMessageID() + ")"));
        }
        boolean withNs = false;
        String nsPrefix = null;
        String nsURI = null;
        Message message = new Message();
        SOAPBody soapBody = msgCtx.getEnvelope().getBody();
        OMNamespace ns = FIXUtils.getNamespaceOfFIXPayload(soapBody);
        if (ns != null) {
            withNs = true;
            nsPrefix = ns.getPrefix();
            nsURI = ns.getNamespaceURI();
        }
        OMElement messageNode = withNs ? soapBody.getFirstChildWithName(new QName(nsURI, "message", nsPrefix)) : soapBody.getFirstChildWithName(new QName("message"));
        Iterator messageElements = messageNode.getChildElements();
        while (messageElements.hasNext()) {
            ByteArrayOutputStream outputStream;
            DataHandler binaryDataHandler;
            String href;
            OMElement child;
            String value;
            String tag;
            OMElement node = (OMElement)messageElements.next();
            if (node.getQName().getLocalPart().equals("header")) {
                Iterator headerElements = node.getChildElements();
                while (headerElements.hasNext()) {
                    OMElement headerNode = (OMElement)headerElements.next();
                    tag = withNs ? headerNode.getAttributeValue(new QName(nsURI, "id", nsPrefix)) : headerNode.getAttributeValue(new QName("id"));
                    value = null;
                    child = headerNode.getFirstElement();
                    if (child != null) {
                        href = withNs ? headerNode.getFirstElement().getAttributeValue(new QName(nsURI, "href", nsPrefix)) : headerNode.getFirstElement().getAttributeValue(new QName("href"));
                        if (href != null) {
                            binaryDataHandler = msgCtx.getAttachment(href.substring(4));
                            outputStream = new ByteArrayOutputStream();
                            binaryDataHandler.writeTo((OutputStream)outputStream);
                            value = new String(outputStream.toByteArray());
                        }
                    } else {
                        value = headerNode.getText();
                    }
                    if (value == null) continue;
                    message.getHeader().setString(Integer.parseInt(tag), value);
                }
                continue;
            }
            if (node.getQName().getLocalPart().equals("body")) {
                this.generateFIXBody(node, (FieldMap)message, msgCtx, withNs, nsURI, nsPrefix);
                continue;
            }
            if (!node.getQName().getLocalPart().equals("trailer")) continue;
            Iterator trailerElements = node.getChildElements();
            while (trailerElements.hasNext()) {
                OMElement trailerNode = (OMElement)trailerElements.next();
                tag = withNs ? trailerNode.getAttributeValue(new QName(nsURI, "id", nsPrefix)) : trailerNode.getAttributeValue(new QName("id"));
                value = null;
                child = trailerNode.getFirstElement();
                if (child != null) {
                    href = withNs ? trailerNode.getFirstElement().getAttributeValue(new QName(nsURI, "id", nsPrefix)) : trailerNode.getFirstElement().getAttributeValue(new QName("href"));
                    if (href != null) {
                        binaryDataHandler = msgCtx.getAttachment(href.substring(4));
                        outputStream = new ByteArrayOutputStream();
                        binaryDataHandler.writeTo((OutputStream)outputStream);
                        value = new String(outputStream.toByteArray());
                    }
                } else {
                    value = trailerNode.getText();
                }
                if (value == null) continue;
                message.getTrailer().setString(Integer.parseInt(tag), value);
            }
        }
        return message;
    }

    public static String[] generateEPRs(SocketAcceptor acceptor, String serviceName, String ip) {
        Map socketAddresses = acceptor.getAcceptorAddresses();
        ArrayList sessions = acceptor.getSessions();
        String[] EPRList = new String[sessions.size()];
        int i = 0;
        while (i < sessions.size()) {
            String targetLocationID;
            String senderLocationID;
            String targetSubID;
            String senderSubID;
            SessionID sessionID = (SessionID)sessions.get(i);
            InetSocketAddress socketAddress = (InetSocketAddress)socketAddresses.get(sessionID);
            EPRList[i] = "fix://" + ip + ":" + socketAddress.getPort() + "?" + "BeginString" + "=" + sessionID.getBeginString() + "&" + "SenderCompID" + "=" + sessionID.getTargetCompID() + "&" + "TargetCompID" + "=" + sessionID.getSenderCompID();
            String sessionQualifier = sessionID.getSessionQualifier();
            if (sessionQualifier != null && !sessionQualifier.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&SessionQualifier=" + sessionQualifier;
            }
            if ((senderSubID = sessionID.getSenderSubID()) != null && !senderSubID.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&SenderSubID=" + senderSubID;
            }
            if ((targetSubID = sessionID.getTargetSubID()) != null && !targetSubID.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&TargetSubID=" + targetSubID;
            }
            if ((senderLocationID = sessionID.getSenderLocationID()) != null && !senderLocationID.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&SenderLocationID=" + senderLocationID;
            }
            if ((targetLocationID = sessionID.getTargetLocationID()) != null && !targetLocationID.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&TargetLocationID=" + targetLocationID;
            }
            int n = i++;
            EPRList[n] = EPRList[n] + "&Service=" + serviceName;
        }
        return EPRList;
    }

    public static String[] getEPRs(SessionSettings settings) throws FieldConvertError, ConfigError {
        Iterator sessions = settings.sectionIterator();
        String[] EPRs = new String[settings.size()];
        int i = 0;
        while (sessions.hasNext()) {
            String paramValue;
            SessionID session = (SessionID)sessions.next();
            String EPR = "fix://";
            EPR = EPR + settings.getString(session, "SocketConnectHost");
            EPR = EPR + ":" + settings.getString(session, "SocketConnectPort");
            EPR = EPR + "?BeginString=";
            EPR = EPR + settings.getString(session, "BeginString");
            EPR = EPR + "&SenderCompID=";
            EPR = EPR + settings.getString(session, "SenderCompID");
            EPR = EPR + "&TargetCompID=";
            EPR = EPR + settings.getString(session, "TargetCompID");
            try {
                paramValue = settings.getString(session, "SenderSubID");
                if (paramValue != null) {
                    EPR = EPR + "&SenderSubID=";
                    EPR = EPR + paramValue;
                }
            }
            catch (ConfigError ignore) {
                // empty catch block
            }
            try {
                paramValue = settings.getString(session, "SenderLocationID");
                if (paramValue != null) {
                    EPR = EPR + "&SenderLocationID=";
                    EPR = EPR + paramValue;
                }
            }
            catch (ConfigError ignore) {
                // empty catch block
            }
            try {
                paramValue = settings.getString(session, "TargetSubID");
                if (paramValue != null) {
                    EPR = EPR + "&TargetSubID=";
                    EPR = EPR + paramValue;
                }
            }
            catch (ConfigError ignore) {
                // empty catch block
            }
            try {
                paramValue = settings.getString(session, "TargetLocationID");
                if (paramValue != null) {
                    EPR = EPR + "&TargetLocationID=";
                    EPR = EPR + paramValue;
                }
            }
            catch (ConfigError ignore) {
                // empty catch block
            }
            EPRs[i] = EPR;
        }
        return EPRs;
    }

    public static boolean compareURLs(String url1, String url2) {
        if (!url1.substring(0, url1.indexOf("?")).equals(url2.substring(0, url2.indexOf("?")))) {
            return false;
        }
        Hashtable properties1 = BaseUtils.getEPRProperties((String)url1);
        Hashtable properties2 = BaseUtils.getEPRProperties((String)url2);
        for (Map.Entry entry : properties1.entrySet()) {
            if (!properties2.containsKey(entry.getKey())) {
                return false;
            }
            if (((String)properties1.get(entry.getKey())).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> getMessageForwardingParameters(Message message) {
        HashMap<String, String> map = new HashMap<String, String>();
        String value = FIXUtils.getHeaderFieldValue(message, 8);
        map.put("BeginString", value);
        value = FIXUtils.getHeaderFieldValue(message, 49);
        map.put("SenderCompID", value);
        value = FIXUtils.getHeaderFieldValue(message, 50);
        map.put("SenderSubID", value);
        value = FIXUtils.getHeaderFieldValue(message, 142);
        map.put("SenderLocationID", value);
        value = FIXUtils.getHeaderFieldValue(message, 56);
        map.put("TargetCompID", value);
        value = FIXUtils.getHeaderFieldValue(message, 128);
        map.put("DeliverToCompID", value);
        value = FIXUtils.getHeaderFieldValue(message, 129);
        map.put("DeliverToSubID", value);
        value = FIXUtils.getHeaderFieldValue(message, 145);
        map.put("DeliverToLocationID", value);
        value = FIXUtils.getHeaderFieldValue(message, 115);
        map.put("OnBehalfOfCompID", value);
        value = FIXUtils.getHeaderFieldValue(message, 116);
        map.put("OnBehalfOfSubID", value);
        value = FIXUtils.getHeaderFieldValue(message, 144);
        map.put("OnBehalfOfLocationID", value);
        return map;
    }

    private static String getHeaderFieldValue(Message message, int tag) {
        try {
            return message.getHeader().getString(tag);
        }
        catch (FieldNotFound fieldNotFound) {
            return null;
        }
    }

    public static String getServiceName(MessageContext msgCtx) throws AxisFault {
        String serviceName;
        String serviceName2;
        Object serviceParam = msgCtx.getProperty("transport.fix.ServiceName");
        if (serviceParam != null && (serviceName2 = serviceParam.toString()) != null && !serviceName2.equals("")) {
            return serviceName2;
        }
        Map trpHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (trpHeaders != null && (serviceName = (String)trpHeaders.get("service")) != null) {
            return serviceName;
        }
        throw new AxisFault("Unable to find a valid service for the message");
    }

    public static String getFixApplication(MessageContext msgCtx) {
        Map trpHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        String fixApplication = null;
        if (trpHeaders != null) {
            fixApplication = (String)trpHeaders.get("fixApplication");
        }
        return fixApplication;
    }

    public static Map<String, String> getTransportHeaders(String serviceName, String fixApplication) {
        HashMap<String, String> trpHeaders = new HashMap<String, String>();
        trpHeaders.put("service", serviceName);
        trpHeaders.put("fixApplication", fixApplication);
        return trpHeaders;
    }

    public static String[] getSocketAddressElements(String fixEPR) throws AxisFault {
        String address;
        String[] socketAddressElemets;
        int propPos = fixEPR.indexOf("?");
        if (propPos != -1 && fixEPR.startsWith("fix://") && (socketAddressElemets = (address = fixEPR.substring("fix://".length(), propPos)).split(":")).length == 2) {
            return socketAddressElemets;
        }
        throw new AxisFault("Malformed FIX EPR: " + fixEPR);
    }

    public static int getSequenceNumber(MessageContext msgCtx) {
        OMElement messageNode;
        String value;
        SOAPBody body = msgCtx.getEnvelope().getBody();
        OMNamespace ns = FIXUtils.getNamespaceOfFIXPayload(body);
        int seqNum = ns == null ? ((value = (messageNode = body.getFirstChildWithName(new QName("message"))).getAttributeValue(new QName("counter"))) != null ? Integer.parseInt(value) : -1) : FIXUtils.getSequenceNumber(body, ns);
        return seqNum;
    }

    private static int getSequenceNumber(SOAPBody body, OMNamespace ns) {
        OMElement messageNode = body.getFirstChildWithName(new QName(ns.getNamespaceURI(), "message", ns.getPrefix()));
        String value = messageNode.getAttributeValue(new QName(ns.getNamespaceURI(), "counter", ns.getPrefix()));
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public static String getSourceSession(MessageContext msgCtx) {
        String srcSession;
        SOAPBody body = msgCtx.getEnvelope().getBody();
        OMNamespace ns = FIXUtils.getNamespaceOfFIXPayload(body);
        if (ns == null) {
            OMElement messageNode = body.getFirstChildWithName(new QName("message"));
            srcSession = messageNode.getAttributeValue(new QName("inSession"));
        } else {
            srcSession = FIXUtils.getSourceSession(body, ns);
        }
        return srcSession;
    }

    private static String getSourceSession(SOAPBody body, OMNamespace ns) {
        OMElement messageNode = body.getFirstChildWithName(new QName(ns.getNamespaceURI(), "message", ns.getPrefix()));
        return messageNode.getAttributeValue(new QName(ns.getNamespaceURI(), "inSession", ns.getPrefix()));
    }

    private static void createOMText(SOAPFactory soapFactory, OMElement field, String text) {
        if (text == null) {
            return;
        }
        if (text.indexOf(60) == -1 && text.indexOf(38) == -1 && text.indexOf(62) == -1) {
            soapFactory.createOMText((OMContainer)field, text);
        } else {
            soapFactory.createOMText((OMContainer)field, text, 12);
        }
    }

    public static OMNamespace getNamespaceOfFIXPayload(SOAPBody fixBody) {
        return fixBody.getFirstElementNS();
    }
}

