/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.format.DataSourceMessageBuilder;
import org.apache.axis2.format.ManagedDataSource;
import org.apache.axis2.format.ManagedDataSourceFactory;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.AbstractPollingTransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.synapse.transport.vfs.FileObjectDataSource;
import org.apache.synapse.transport.vfs.PollTableEntry;
import org.apache.synapse.transport.vfs.VFSOutTransportInfo;
import org.apache.synapse.transport.vfs.VFSUtils;

public class VFSTransportListener
extends AbstractPollingTransportListener<PollTableEntry>
implements ManagementSupport {
    public static final String TRANSPORT_NAME = "vfs";
    public static final String DELETE = "DELETE";
    public static final String MOVE = "MOVE";
    private FileSystemManager fsManager = null;
    private boolean globalFileLockingFlag = true;
    private WorkerPool workerPool = null;
    private static final int STATE_STOPPED = 0;
    private static final int STATE_RUNNING = 1;
    private volatile int removeTaskState = 0;

    protected void doInit() throws AxisFault {
        super.doInit();
        try {
            String strLockingFlag;
            StandardFileSystemManager fsm = new StandardFileSystemManager();
            fsm.setConfiguration(((Object)((Object)this)).getClass().getClassLoader().getResource("providers.xml"));
            fsm.init();
            this.workerPool = ((AbstractPollingTransportListener)this).workerPool;
            this.fsManager = fsm;
            Parameter lockFlagParam = this.getTransportInDescription().getParameter("transport.vfs.Locking");
            if (lockFlagParam != null && "disable".equals(strLockingFlag = lockFlagParam.getValue().toString())) {
                this.globalFileLockingFlag = false;
            }
        }
        catch (FileSystemException e) {
            this.handleException("Error initializing the file transport : " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void poll(PollTableEntry entry) {
        this.scanFileOrDirectory(entry, entry.getFileURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFileOrDirectory(PollTableEntry entry, String fileURI) {
        FileObject fileObject = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Scanning directory or file : " + VFSUtils.maskURLPassword(fileURI)));
        }
        boolean wasError = true;
        int retryCount = 0;
        int maxRetryCount = entry.getMaxRetryCount();
        long reconnectionTimeout = entry.getReconnectTimeout();
        while (wasError) {
            try {
                ++retryCount;
                fileObject = this.fsManager.resolveFile(fileURI);
                if (fileObject == null) {
                    this.log.error((Object)"fileObject is null");
                    throw new FileSystemException("fileObject is null");
                }
                wasError = false;
            }
            catch (FileSystemException e) {
                if (retryCount >= maxRetryCount) {
                    this.processFailure("Repeatedly failed to resolve the file URI: " + VFSUtils.maskURLPassword(fileURI), (Exception)((Object)e), entry);
                    return;
                }
                this.log.warn((Object)("Failed to resolve the file URI: " + VFSUtils.maskURLPassword(fileURI) + ", in attempt " + retryCount + ", " + e.getMessage() + " Retrying in " + reconnectionTimeout + " milliseconds."));
            }
            if (!wasError) continue;
            try {
                Thread.sleep(reconnectionTimeout);
            }
            catch (InterruptedException e2) {
                this.log.error((Object)"Thread was interrupted while waiting to reconnect.", (Throwable)e2);
            }
        }
        try {
            if (fileObject.exists() && fileObject.isReadable()) {
                entry.setLastPollState(3);
                FileObject[] children = null;
                try {
                    children = fileObject.getChildren();
                }
                catch (FileSystemException ignore) {
                    // empty catch block
                }
                if (children == null || children.length == 0) {
                    boolean isFailedRecord = false;
                    if (entry.getMoveAfterMoveFailure() != null) {
                        isFailedRecord = this.isFailedRecord(fileObject, entry);
                    }
                    if (fileObject.getType() == FileType.FILE && !isFailedRecord) {
                        if (!entry.isFileLockingEnabled() || entry.isFileLockingEnabled() && VFSUtils.acquireLock(this.fsManager, fileObject)) {
                            try {
                                this.processFile(entry, fileObject);
                                entry.setLastPollState(0);
                                this.metrics.incrementMessagesReceived();
                            }
                            catch (AxisFault e) {
                                this.logException("Error processing File URI : " + VFSUtils.maskURLPassword(fileObject.getName().getURI()), (Exception)((Object)e));
                                entry.setLastPollState(2);
                                this.metrics.incrementFaultsReceiving();
                            }
                            try {
                                this.moveOrDeleteAfterProcessing(entry, fileObject);
                            }
                            catch (AxisFault axisFault) {
                                this.logException("File object '" + fileObject.getURL().toString() + "' " + "cloud not be moved", (Exception)((Object)axisFault));
                                entry.setLastPollState(2);
                                String timeStamp = VFSUtils.getSystemTime(entry.getFailedRecordTimestampFormat());
                                this.addFailedRecord(entry, fileObject, timeStamp);
                            }
                            if (entry.isFileLockingEnabled()) {
                                VFSUtils.releaseLock(this.fsManager, fileObject);
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Removed the lock file '" + fileObject.toString() + ".lock' of the file '" + fileObject.toString()));
                                }
                            }
                        } else if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Couldn't get the lock for processing the file : " + VFSUtils.maskURLPassword(fileObject.getName().getURI())));
                        } else if (isFailedRecord) {
                            if (entry.isFileLockingEnabled()) {
                                VFSUtils.releaseLock(this.fsManager, fileObject);
                            }
                            if (this.fsManager.resolveFile(fileObject.getURL().toString()) != null && this.removeTaskState == 0 && entry.getMoveAfterMoveFailure() != null) {
                                this.workerPool.execute((Runnable)new FileRemoveTask(entry, fileObject));
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("File '" + fileObject.getURL() + "' has been marked as a failed" + " record, it will not process"));
                            }
                        }
                    }
                } else {
                    int failCount = 0;
                    int successCount = 0;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("File name pattern : " + entry.getFileNamePattern()));
                    }
                    for (FileObject child : children) {
                        boolean isFailedRecord = false;
                        if (entry.getMoveAfterMoveFailure() != null) {
                            isFailedRecord = this.isFailedRecord(child, entry);
                        }
                        if (entry.getFileNamePattern() != null && child.getName().getBaseName().matches(entry.getFileNamePattern())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Matching file : " + child.getName().getBaseName()));
                            }
                            if (entry.isFileLockingEnabled() && (!entry.isFileLockingEnabled() || !VFSUtils.acquireLock(this.fsManager, child)) || isFailedRecord) continue;
                            try {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Processing file :" + child));
                                }
                                this.processFile(entry, child);
                                ++successCount;
                                entry.setLastPollState(0);
                                this.metrics.incrementMessagesReceived();
                            }
                            catch (Exception e) {
                                this.logException("Error processing File URI : " + VFSUtils.maskURLPassword(child.getName().getURI()), e);
                                ++failCount;
                                entry.setLastPollState(2);
                                this.metrics.incrementFaultsReceiving();
                            }
                            try {
                                this.moveOrDeleteAfterProcessing(entry, child);
                                continue;
                            }
                            catch (AxisFault axisFault) {
                                this.logException("File object '" + child.getURL().toString() + "'cloud not be moved", (Exception)((Object)axisFault));
                                ++failCount;
                                entry.setLastPollState(2);
                                String timeStamp = VFSUtils.getSystemTime(entry.getFailedRecordTimestampFormat());
                                this.addFailedRecord(entry, child, timeStamp);
                                continue;
                            }
                            finally {
                                if (entry.isFileLockingEnabled()) {
                                    VFSUtils.releaseLock(this.fsManager, child);
                                }
                            }
                        }
                        if (entry.getFileNamePattern() != null && !child.getName().getBaseName().matches(entry.getFileNamePattern())) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug((Object)("Non-Matching file : " + child.getName().getBaseName()));
                            continue;
                        }
                        if (!isFailedRecord) continue;
                        if (entry.isFileLockingEnabled()) {
                            VFSUtils.releaseLock(this.fsManager, child);
                            VFSUtils.releaseLock(this.fsManager, fileObject);
                        }
                        if (this.fsManager.resolveFile(child.getURL().toString()) != null && this.removeTaskState == 0 && entry.getMoveAfterMoveFailure() != null) {
                            this.workerPool.execute((Runnable)new FileRemoveTask(entry, child));
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("File '" + fileObject.getURL() + "' has been marked as a failed record, it will not " + "process"));
                    }
                    if (failCount == 0 && successCount > 0) {
                        entry.setLastPollState(0);
                    } else if (successCount == 0 && failCount > 0) {
                        entry.setLastPollState(2);
                    } else {
                        entry.setLastPollState(1);
                    }
                }
                long now = System.currentTimeMillis();
                entry.setLastPollTime(now);
                entry.setNextPollTime(now + entry.getPollInterval());
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unable to access or read file or directory : " + VFSUtils.maskURLPassword(fileURI) + "." + " Reason: " + (fileObject.exists() ? (fileObject.isReadable() ? "Unknown reason" : "The file can not be read!") : "The file does not exists!")));
            }
            this.onPollCompletion(entry);
        }
        catch (FileSystemException e) {
            this.processFailure("Error checking for existence and readability : " + VFSUtils.maskURLPassword(fileURI), (Exception)((Object)e), entry);
        }
    }

    private void moveOrDeleteAfterProcessing(PollTableEntry entry, FileObject fileObject) throws AxisFault {
        block14: {
            String moveToDirectoryURI = null;
            try {
                switch (entry.getLastPollState()) {
                    case 0: {
                        if (entry.getActionAfterProcess() != 1) break;
                        moveToDirectoryURI = entry.getMoveAfterProcess();
                        break;
                    }
                    case 2: {
                        if (entry.getActionAfterFailure() != 1) break;
                        moveToDirectoryURI = entry.getMoveAfterFailure();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (moveToDirectoryURI != null) {
                    FileObject moveToDirectory = this.fsManager.resolveFile(moveToDirectoryURI);
                    String prefix = entry.getMoveTimestampFormat() != null ? entry.getMoveTimestampFormat().format(new Date()) : "";
                    FileObject dest = moveToDirectory.resolveFile(prefix + fileObject.getName().getBaseName());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Moving to file :" + VFSUtils.maskURLPassword(dest.getName().getURI())));
                    }
                    try {
                        fileObject.moveTo(dest);
                    }
                    catch (FileSystemException e) {
                        this.handleException("Error moving file : " + fileObject + " to " + moveToDirectoryURI, (Exception)((Object)e));
                    }
                    break block14;
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Deleting file :" + fileObject));
                    }
                    fileObject.close();
                    if (!fileObject.delete()) {
                        String msg = "Cannot delete file : " + fileObject;
                        this.log.error((Object)msg);
                        throw new AxisFault(msg);
                    }
                }
                catch (FileSystemException e) {
                    this.log.error((Object)("Error deleting file : " + fileObject), (Throwable)e);
                }
            }
            catch (FileSystemException e) {
                this.log.error((Object)("Error resolving directory to move after processing : " + moveToDirectoryURI), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(PollTableEntry entry, FileObject file) throws AxisFault {
        try {
            ManagedDataSource dataSource;
            AutoCloseInputStream in;
            SOAPBuilder builder;
            FileContent content = file.getContent();
            String fileName = file.getName().getBaseName();
            String filePath = file.getName().getPath();
            this.metrics.incrementBytesReceived(content.getSize());
            HashMap<String, Object> transportHeaders = new HashMap<String, Object>();
            transportHeaders.put("FILE_PATH", filePath);
            transportHeaders.put("FILE_NAME", fileName);
            try {
                transportHeaders.put("FILE_LENGTH", content.getSize());
                transportHeaders.put("LAST_MODIFIED", content.getLastModifiedTime());
            }
            catch (FileSystemException ignore) {
                // empty catch block
            }
            MessageContext msgContext = entry.createMessageContext();
            String contentType = entry.getContentType();
            if (BaseUtils.isBlank((String)contentType)) {
                if (file.getName().getExtension().toLowerCase().endsWith(".xml")) {
                    contentType = "text/xml";
                } else if (file.getName().getExtension().toLowerCase().endsWith(".txt")) {
                    contentType = "text/plain";
                }
            } else {
                String charSetEnc = null;
                try {
                    if (contentType != null) {
                        charSetEnc = new ContentType(contentType).getParameter("charset");
                    }
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            }
            if (contentType == null) {
                if (entry.getContentType() != null) {
                    contentType = entry.getContentType();
                } else if (VFSUtils.getProperty(content, "Content-Type") != null) {
                    contentType = VFSUtils.getProperty(content, "Content-Type");
                }
            }
            msgContext.removeProperty("ClientApiNonBlocking");
            String replyFileURI = entry.getReplyFileURI();
            if (replyFileURI != null) {
                msgContext.setProperty("OutTransportInfo", (Object)new VFSOutTransportInfo(replyFileURI, entry.isFileLockingEnabled()));
            }
            if (contentType == null) {
                this.log.debug((Object)"No content type specified. Using SOAP builder.");
                builder = new SOAPBuilder();
            } else {
                int index = contentType.indexOf(59);
                String type = index > 0 ? contentType.substring(0, index) : contentType;
                builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)msgContext);
                if (builder == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                    }
                    builder = new SOAPBuilder();
                }
            }
            if (builder instanceof DataSourceMessageBuilder && entry.isStreaming()) {
                in = null;
                dataSource = ManagedDataSourceFactory.create((DataSource)new FileObjectDataSource(file, contentType));
            } else {
                in = new AutoCloseInputStream(content.getInputStream());
                dataSource = null;
            }
            try {
                OMElement documentElement = in != null ? builder.processDocument((InputStream)in, contentType, msgContext) : ((DataSourceMessageBuilder)builder).processDocument((DataSource)dataSource, contentType, msgContext);
                msgContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
                this.handleIncomingMessage(msgContext, transportHeaders, null, contentType);
            }
            finally {
                if (dataSource != null) {
                    dataSource.destroy();
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processed file : " + file + " of Content-type : " + contentType));
            }
        }
        catch (FileSystemException e) {
            this.handleException("Error reading file content or attributes : " + file, (Exception)((Object)e));
        }
        finally {
            try {
                file.close();
            }
            catch (FileSystemException fileSystemException) {}
        }
    }

    protected PollTableEntry createEndpoint() {
        return new PollTableEntry(this.globalFileLockingFlag);
    }

    private synchronized void addFailedRecord(PollTableEntry pollTableEntry, FileObject failedObject, String timeString) {
        try {
            String record = failedObject.getName().getBaseName() + " " + timeString;
            String recordFile = pollTableEntry.getFailedRecordFileDestination() + pollTableEntry.getFailedRecordFileName();
            File failedRecordFile = new File(recordFile);
            if (!failedRecordFile.exists()) {
                FileUtils.writeStringToFile((File)failedRecordFile, (String)record);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Added fail record '" + record + "' into the record file '" + recordFile + "'"));
                }
            } else {
                List content = FileUtils.readLines((File)failedRecordFile);
                if (!content.contains(record)) {
                    content.add(record);
                }
                FileUtils.writeLines((File)failedRecordFile, (Collection)content);
            }
        }
        catch (IOException e) {
            this.log.fatal((Object)"Failure while writing the failed records!", (Throwable)e);
        }
    }

    private boolean isFailedRecord(FileObject fileObject, PollTableEntry entry) {
        String failedFile = entry.getFailedRecordFileDestination() + entry.getFailedRecordFileName();
        File file = new File(failedFile);
        if (file.exists()) {
            try {
                List list = FileUtils.readLines((File)file);
                for (Object aList : list) {
                    String str = (String)aList;
                    StringTokenizer st = new StringTokenizer(str, " ");
                    String fileName = st.nextToken();
                    if (fileName == null || !fileName.equals(fileObject.getName().getBaseName())) continue;
                    return true;
                }
            }
            catch (IOException e) {
                this.log.fatal((Object)("Error while reading the file '" + failedFile + "'"), (Throwable)e);
            }
        }
        return false;
    }

    private class FileRemoveTask
    implements Runnable {
        private FileObject failedFileObject;
        private PollTableEntry pollTableEntry;

        public FileRemoveTask(PollTableEntry pollTableEntry, FileObject fileObject) {
            this.pollTableEntry = pollTableEntry;
            this.failedFileObject = fileObject;
        }

        @Override
        public void run() {
            if (VFSTransportListener.this.log.isDebugEnabled()) {
                VFSTransportListener.this.log.debug((Object)("New file remove task is starting..thread id : " + Thread.currentThread().getName()));
            }
            boolean isDeletionSucceed = false;
            int nextRetryDuration = this.pollTableEntry.getNextRetryDuration();
            int count = 0;
            while (!isDeletionSucceed) {
                try {
                    this.reTryFailedMove(this.pollTableEntry, this.failedFileObject);
                    isDeletionSucceed = true;
                    VFSTransportListener.this.removeTaskState = 0;
                }
                catch (AxisFault axisFault) {
                    VFSTransportListener.this.removeTaskState = 1;
                    try {
                        VFSTransportListener.this.log.error((Object)("Remove attempt '" + count++ + "' failed for the file '" + this.failedFileObject.getURL().toString() + "', next re-try will be " + "after '" + nextRetryDuration + "' milliseconds"));
                    }
                    catch (FileSystemException e) {
                        VFSTransportListener.this.log.error((Object)("Error while retrying the file url of the file object '" + this.failedFileObject + "'"));
                    }
                    try {
                        Thread.sleep(nextRetryDuration);
                    }
                    catch (InterruptedException ignore) {}
                }
            }
        }

        private synchronized void reTryFailedMove(PollTableEntry entry, FileObject fileObject) throws AxisFault {
            try {
                String moveToDirectoryURI = entry.getMoveAfterMoveFailure();
                FileObject moveToDirectory = VFSTransportListener.this.fsManager.resolveFile(moveToDirectoryURI);
                if (!moveToDirectory.exists()) {
                    moveToDirectory.createFolder();
                }
                String prefix = entry.getMoveTimestampFormat() != null ? entry.getMoveTimestampFormat().format(new Date()) : "";
                FileObject dest = moveToDirectory.resolveFile(prefix + fileObject.getName().getBaseName());
                if (VFSTransportListener.this.log.isDebugEnabled()) {
                    VFSTransportListener.this.log.debug((Object)("The failed file is moving to :" + VFSUtils.maskURLPassword(dest.getName().getURI())));
                }
                try {
                    fileObject.moveTo(dest);
                }
                catch (FileSystemException e) {
                    VFSTransportListener.this.handleException("Error moving the failed file : " + fileObject + " to " + moveToDirectoryURI, (Exception)((Object)e));
                }
            }
            catch (FileSystemException e) {
                VFSTransportListener.this.handleException("Cloud not move the failed file object '" + fileObject + "'", (Exception)((Object)e));
            }
            catch (IOException e) {
                VFSTransportListener.this.handleException("Cloud not create the folder", e);
            }
        }
    }
}

