/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn.logging;

import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.logging.Log;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.NHttpMessageWriterFactory;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;

public class LoggingNHttpServerConnection
extends DefaultNHttpServerConnection {
    private final Log log;

    public LoggingNHttpServerConnection(IOSession session, int bufferSize, int fragmentSizeHint, ByteBufferAllocator allocator, CharsetDecoder charDecoder, CharsetEncoder charEncoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, Log log) {
        super(session, bufferSize, fragmentSizeHint, allocator, charDecoder, charEncoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestParserFactory, responseWriterFactory);
        this.log = log;
    }

    public void close() throws IOException {
        this.log.debug((Object)"Close connection");
        super.close();
    }

    public void shutdown() throws IOException {
        this.log.debug((Object)"Shutdown connection");
        super.shutdown();
    }

    public void submitResponse(HttpResponse response) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + (Object)((Object)this) + ": " + response.getStatusLine().toString()));
        }
        super.submitResponse(response);
    }

    public void consumeInput(NHttpServerEventHandler handler) {
        this.log.debug((Object)"Consume input");
        super.consumeInput(handler);
    }

    public void produceOutput(NHttpServerEventHandler handler) {
        this.log.debug((Object)"Produce output");
        super.produceOutput(handler);
    }
}

