/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.passthru.HttpGetRequestProcessor;
import org.apache.synapse.transport.passthru.SourceHandler;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.apache.synapse.transport.passthru.jmx.TransportView;
import org.apache.synapse.transport.utils.conn.logging.LoggingUtils;

public class PassThroughHttpListener
implements TransportListener {
    protected Log log = LogFactory.getLog(this.getClass());
    private DefaultListeningIOReactor ioReactor;
    private SourceConfiguration sourceConfiguration = null;
    private SSLContext sslContext = null;
    private SSLSetupHandler sslSetupHandler = null;
    private Map<String, String> serviceNameToEPRMap = new HashMap<String, String>();
    private Map<String, String> eprToServiceNameMap = new HashMap<String, String>();
    private final AxisObserver axisObserver = new GenericAxisObserver();
    private volatile int state = 0;
    private String namePrefix;

    public void init(ConfigurationContext cfgCtx, TransportInDescription transportInDescription) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initializing pass-through HTTP/S Listener...");
        }
        int portOffset = Integer.parseInt(System.getProperty("portOffset", "0"));
        Parameter portParam = transportInDescription.getParameter("port");
        int port = Integer.parseInt(portParam.getValue().toString());
        portParam.setValue((Object)String.valueOf(port += portOffset));
        portParam.getParameterElement().setText(String.valueOf(port));
        Object obj = cfgCtx.getProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL");
        WorkerPool workerPool = null;
        if (obj != null) {
            workerPool = (WorkerPool)obj;
        }
        this.sslContext = this.getSSLContext(transportInDescription);
        this.sslSetupHandler = this.getSSLSetupHandler(transportInDescription);
        this.namePrefix = this.sslContext == null ? "HTTP" : "HTTPS";
        this.sourceConfiguration = new SourceConfiguration(cfgCtx, transportInDescription, workerPool, this.sslContext != null);
        cfgCtx.getAxisConfiguration().addObservers(this.axisObserver);
        cfgCtx.setProperty("service.epr.map", this.eprToServiceNameMap);
        cfgCtx.setProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL", (Object)this.sourceConfiguration.getWorkerPool());
        PassThroughTransportMetricsCollector metrics = new PassThroughTransportMetricsCollector(true, this.sslContext != null);
        MBeanRegistrar.getInstance().registerMBean((Object)new TransportView(this, null, metrics, null), "Transport", "passthru-" + this.namePrefix.toLowerCase() + "-receiver");
        this.sourceConfiguration.setMetrics(metrics);
    }

    public void start() throws AxisFault {
        ListenerEndpoint endpoint;
        this.log.info((Object)("Starting pass-through " + this.namePrefix + " listener..."));
        try {
            String prefix = this.namePrefix + "-PT-Listener I/O Dispatcher";
            this.ioReactor = new DefaultListeningIOReactor(this.sourceConfiguration.getReactorConfig(true), (ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " Thread Group"), prefix));
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    PassThroughHttpListener.this.log.warn((Object)("System may be unstable: " + PassThroughHttpListener.this.namePrefix + " ListeningIOReactor encountered a checked exception."), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    PassThroughHttpListener.this.log.warn((Object)("System may be unstable: " + PassThroughHttpListener.this.namePrefix + " ListeningIOReactor encountered a runtime exception."), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOReactorException e) {
            this.handleException("Error starting " + this.namePrefix + " ListeningIOReactor", (Exception)((Object)e));
        }
        SourceHandler handler = new SourceHandler(this.sourceConfiguration);
        final IOEventDispatch ioEventDispatch = this.getEventDispatch(handler, this.sslContext, this.sslSetupHandler, this.sourceConfiguration.getConnectionConfig());
        if (this.sourceConfiguration.getBindAddress() != null) {
            try {
                endpoint = this.ioReactor.listen((SocketAddress)new InetSocketAddress(InetAddress.getByName(this.sourceConfiguration.getBindAddress()), this.sourceConfiguration.getPort()));
            }
            catch (UnknownHostException e) {
                this.handleException("Failed to resolve the bind address: " + this.sourceConfiguration.getBindAddress(), e);
                return;
            }
        } else {
            endpoint = this.ioReactor.listen((SocketAddress)new InetSocketAddress(this.sourceConfiguration.getPort()));
        }
        HttpGetRequestProcessor getProcessor = this.sourceConfiguration.getHttpGetRequestProcessor();
        if (getProcessor != null) {
            getProcessor.init(this.sourceConfiguration.getConfigurationContext(), handler);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PassThroughHttpListener.this.ioReactor.execute(ioEventDispatch);
                }
                catch (Exception e) {
                    PassThroughHttpListener.this.log.fatal((Object)("Exception encountered in the " + PassThroughHttpListener.this.namePrefix + " listener. " + "No more connections will be accepted by this transport."), (Throwable)e);
                }
                PassThroughHttpListener.this.log.info((Object)(PassThroughHttpListener.this.namePrefix + " listener shutdown."));
            }
        }, "PassThrough" + this.namePrefix + "Listener");
        t.start();
        try {
            endpoint.waitFor();
        }
        catch (InterruptedException e) {
            this.log.warn((Object)("Pass-through " + this.namePrefix + " listener startup was interrupted"), (Throwable)e);
        }
        this.state = 1;
        this.log.info((Object)("Pass-through " + this.namePrefix + " listener " + "started on port: " + this.sourceConfiguration.getPort()));
    }

    private void handleException(String s, Exception e) throws AxisFault {
        this.log.error((Object)s, (Throwable)e);
        throw new AxisFault(s, (Throwable)e);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String trailer = "";
        if (serviceName.indexOf(47) != -1) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("/"));
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        if (serviceName.indexOf(46) != -1) {
            trailer = trailer + serviceName.substring(serviceName.indexOf("."));
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        }
        EndpointReference[] endpointReferences = new EndpointReference[]{this.serviceNameToEPRMap.containsKey(serviceName) ? new EndpointReference(this.sourceConfiguration.getCustomEPRPrefix() + this.serviceNameToEPRMap.get(serviceName) + trailer) : new EndpointReference(this.sourceConfiguration.getServiceEPRPrefix() + serviceName + trailer)};
        return endpointReferences;
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void stop() throws AxisFault {
        this.log.info((Object)("Stopping pass-through " + this.namePrefix + " listener.."));
        try {
            this.ioReactor.shutdown();
        }
        catch (IOException e) {
            this.handleException("Error shutting down " + this.namePrefix + " listening IO reactor", e);
        }
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying pass-through " + this.namePrefix + " listener"));
        }
        this.ioReactor = null;
        this.sourceConfiguration.getConfigurationContext().getAxisConfiguration().getObserversList().remove(this.axisObserver);
        MBeanRegistrar.getInstance().unRegisterMBean("Transport", "passthru-" + this.namePrefix.toLowerCase() + "-receiver");
        this.sourceConfiguration.getMetrics().destroy();
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            this.ioReactor.pause();
            this.state = 2;
            this.log.info((Object)(this.namePrefix + " Listener Paused"));
        }
        catch (IOException e) {
            this.handleException("Error pausing IOReactor", e);
        }
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        try {
            this.ioReactor.resume();
            this.state = 1;
            this.log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + "Listener Resumed"));
        }
        catch (IOException e) {
            this.handleException("Error resuming IOReactor", e);
        }
    }

    public void maintenanceShutdown(long milliSecs) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.pause();
            this.ioReactor.shutdown(milliSecs);
            this.state = 0;
            this.log.info((Object)("Listener shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenance", e);
        }
    }

    private boolean ignoreService(AxisService service) {
        return service.getName().startsWith("__") || JavaUtils.isTrueExplicitly((Object)service.getParameter("hiddenService"));
    }

    private void addToServiceURIMap(AxisService service) {
        Parameter param = service.getParameter("ServiceURI");
        if (param != null) {
            String uriLocation = param.getValue().toString();
            if (uriLocation.startsWith("/")) {
                uriLocation = uriLocation.substring(1);
            }
            this.serviceNameToEPRMap.put(service.getName(), uriLocation);
            this.eprToServiceNameMap.put(uriLocation, service.getName());
        }
    }

    private void removeServiceFromURIMap(AxisService service) {
        this.eprToServiceNameMap.remove(this.serviceNameToEPRMap.get(service.getName()));
        this.serviceNameToEPRMap.remove(service.getName());
    }

    protected IOEventDispatch getEventDispatch(NHttpServerEventHandler handler, SSLContext sslContext, SSLSetupHandler sslSetupHandler, ConnectionConfig config) {
        return LoggingUtils.getServerIODispatch(handler, config);
    }

    protected SSLContext getSSLContext(TransportInDescription transportIn) throws AxisFault {
        return null;
    }

    protected SSLSetupHandler getSSLSetupHandler(TransportInDescription transportOut) throws AxisFault {
        return null;
    }

    private class GenericAxisObserver
    implements AxisObserver {
        private GenericAxisObserver() {
        }

        public void init(AxisConfiguration axisConfig) {
        }

        public void serviceUpdate(AxisEvent event, AxisService service) {
            if (!PassThroughHttpListener.this.ignoreService(service) && BaseUtils.isUsingTransport((AxisService)service, (String)PassThroughHttpListener.this.sourceConfiguration.getTransportName())) {
                switch (event.getEventType()) {
                    case 1: {
                        PassThroughHttpListener.this.addToServiceURIMap(service);
                        break;
                    }
                    case 0: {
                        PassThroughHttpListener.this.removeServiceFromURIMap(service);
                        break;
                    }
                    case 3: {
                        PassThroughHttpListener.this.addToServiceURIMap(service);
                        break;
                    }
                    case 2: {
                        PassThroughHttpListener.this.removeServiceFromURIMap(service);
                    }
                }
            }
        }

        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        public void addParameter(Parameter parameter) throws AxisFault {
        }

        public void removeParameter(Parameter parameter) throws AxisFault {
        }

        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        public Parameter getParameter(String name) {
            return null;
        }

        public ArrayList<Parameter> getParameters() {
            return null;
        }

        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    }
}

