/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SharedInputBuffer;
import org.apache.http.nio.util.SharedOutputBuffer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.synapse.commons.jmx.ThreadingView;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;
import org.apache.synapse.transport.nhttp.ClientWorker;
import org.apache.synapse.transport.nhttp.ConnectionPool;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerWorker;
import org.apache.synapse.transport.nhttp.debug.ClientConnectionDebug;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;

public class ClientHandler
implements NHttpClientEventHandler {
    private static final Log log = LogFactory.getLog(ClientHandler.class);
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final ByteBufferAllocator allocator;
    ConfigurationContext cfgCtx = null;
    private NHttpConfiguration cfg = null;
    private WorkerPool workerPool = null;
    private NhttpMetricsCollector metrics = null;
    private String[] warnOnHttp500;
    private boolean countConnections = false;
    private Lock lock = new ReentrantLock();
    private ThreadingView threadingView = null;
    private Map<String, AtomicInteger> openConnections = new HashMap<String, AtomicInteger>();
    public static final String OUTGOING_MESSAGE_CONTEXT = "synapse.axis2_message_context";
    public static final String AXIS2_HTTP_REQUEST = "synapse.axis2-http-request";
    public static final String CLIENT_CONNECTION_DEBUG = "synapse.client-connection-debug";
    public static final String CONNECTION_CREATION_TIME = "synapse.connectionCreationTime";
    public static final String REQUEST_SOURCE_BUFFER = "synapse.request-source-buffer";
    public static final String RESPONSE_SINK_BUFFER = "synapse.response-sink-buffer";
    private static final String CONTENT_TYPE = "Content-Type";

    public ClientHandler(ConfigurationContext cfgCtx, NhttpMetricsCollector metrics) {
        this.cfgCtx = cfgCtx;
        this.httpProcessor = this.getHttpProcessor();
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.metrics = metrics;
        this.allocator = new HeapByteBufferAllocator();
        this.threadingView = new ThreadingView("HttpClientWorker", true, 50.0);
        this.cfg = NHttpConfiguration.getInstance();
        this.workerPool = WorkerPoolFactory.getWorkerPool((int)this.cfg.getClientCoreThreads(), (int)this.cfg.getClientMaxThreads(), (int)this.cfg.getClientKeepalive(), (int)this.cfg.getClientQueueLen(), (String)"Client Worker thread group", (String)"HttpClientWorker");
        Object contentTypeList = cfgCtx.getLocalProperty("warnOnHTTP500");
        if (contentTypeList != null) {
            this.warnOnHttp500 = (String[])contentTypeList;
        }
        this.countConnections = NHttpConfiguration.getInstance().isCountConnections();
        cfgCtx.setProperty("OPEN_CONNNECTIONS_MAP", this.openConnections);
        metrics.setConnectionsPerHosts(this.openConnections);
    }

    public void requestReady(NHttpClientConnection conn) {
    }

    public void submitRequest(NHttpClientConnection conn, Axis2HttpRequest axis2Req) throws ConnectionClosedException {
        this.processConnection(conn, axis2Req);
    }

    public void connected(NHttpClientConnection conn, Object attachment) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ClientHandler connected : " + conn));
        }
        this.metrics.connected();
        conn.getContext().setAttribute(CONNECTION_CREATION_TIME, (Object)System.currentTimeMillis());
        if (this.countConnections) {
            this.recordConnection(conn);
        }
        try {
            this.processConnection(conn, (Axis2HttpRequest)attachment);
        }
        catch (ConnectionClosedException e) {
            this.metrics.incrementFaultsSending();
            this.handleException("I/O Error submitting request : " + e.getMessage(), (Exception)((Object)e), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnection(NHttpClientConnection conn, Axis2HttpRequest axis2Req) throws ConnectionClosedException {
        ClientConnectionDebug cd = (ClientConnectionDebug)axis2Req.getMsgContext().getProperty(CLIENT_CONNECTION_DEBUG);
        if (cd != null) {
            cd.recordRequestStartTime(conn, axis2Req);
            conn.getContext().setAttribute(CLIENT_CONNECTION_DEBUG, (Object)cd);
        }
        try {
            conn.getMetrics().reset();
            Object context = conn.getContext();
            SharedOutputBuffer outputBuffer = new SharedOutputBuffer(this.cfg.getBufferSize(), this.allocator);
            axis2Req.setOutputBuffer((ContentOutputBuffer)outputBuffer);
            context.setAttribute(REQUEST_SOURCE_BUFFER, (Object)outputBuffer);
            context.setAttribute(AXIS2_HTTP_REQUEST, (Object)axis2Req);
            context.setAttribute("http.connection", (Object)conn);
            context.setAttribute("http.target_host", (Object)axis2Req.getHttpHost());
            context.setAttribute(OUTGOING_MESSAGE_CONTEXT, (Object)axis2Req.getMsgContext());
            HttpRequest request = axis2Req.getRequest();
            this.httpProcessor.process(request, context);
            if (axis2Req.getTimeout() > 0) {
                conn.setSocketTimeout(axis2Req.getTimeout());
            }
            context.setAttribute("ENDPOINT_PREFIX", (Object)axis2Req.getEndpointURLPrefix());
            context.setAttribute("HTTP_REQ_METHOD", (Object)request.getRequestLine().getMethod());
            context.setAttribute("http.request", (Object)request);
            this.setServerContextAttribute("REQ_DEPARTURE_TIME", System.currentTimeMillis(), conn);
            conn.submitRequest(request);
        }
        catch (ConnectionClosedException e) {
            throw e;
        }
        catch (IOException e) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsSending();
            }
            this.handleException("I/O Error submitting request : " + e.getMessage(), e, conn);
        }
        catch (HttpException e) {
            if (this.metrics != null) {
                this.metrics.incrementFaultsSending();
            }
            this.handleException("HTTP protocol error submitting request : " + e.getMessage(), (Exception)((Object)e), conn);
        }
        finally {
            Axis2HttpRequest e = axis2Req;
            synchronized (e) {
                axis2Req.setReadyToStream(true);
                axis2Req.notifyAll();
            }
        }
    }

    public void closed(NHttpClientConnection conn) {
        Axis2HttpRequest axis2Request;
        ConnectionPool.forget(conn);
        String message = this.getErrorMessage("Connection close", conn);
        if (log.isTraceEnabled()) {
            log.trace((Object)message);
        }
        if ((axis2Request = (Axis2HttpRequest)conn.getContext().getAttribute(AXIS2_HTTP_REQUEST)) != null && !axis2Request.isCompleted()) {
            this.checkAxisRequestComplete(conn, 101505, message, null);
            this.shutdownConnection(conn, true, "Connection closed before response is received");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.getErrorMessage("Keep-alive connection closed", conn));
            }
            this.shutdownConnection(conn, false, null);
        }
        HttpContext context = conn.getContext();
        context.removeAttribute(RESPONSE_SINK_BUFFER);
        context.removeAttribute(REQUEST_SOURCE_BUFFER);
        this.metrics.disconnected();
    }

    public void timeout(NHttpClientConnection conn) {
        Axis2HttpRequest axis2Request;
        String message = this.getErrorMessage("Connection timeout", conn);
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
        if ((axis2Request = (Axis2HttpRequest)conn.getContext().getAttribute(AXIS2_HTTP_REQUEST)) != null && !axis2Request.isCompleted()) {
            this.checkAxisRequestComplete(conn, 101504, message, null);
            this.shutdownConnection(conn, true, "Connection timeout before response is received");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.getErrorMessage("Keep-alive connection timed out", conn));
            }
            this.shutdownConnection(conn, false, null);
        }
        HttpContext context = conn.getContext();
        context.removeAttribute(RESPONSE_SINK_BUFFER);
        context.removeAttribute(REQUEST_SOURCE_BUFFER);
    }

    public void endOfInput(NHttpClientConnection conn) throws IOException {
        this.closed(conn);
    }

    public void exception(NHttpClientConnection conn, Exception e) {
        if (e instanceof HttpException) {
            this.exception(conn, (HttpException)((Object)e));
        } else if (e instanceof IOException) {
            this.exception(conn, (IOException)e);
        } else {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.shutdownConnection(conn, true, "Error occurred : " + e.getMessage());
        }
    }

    public void exception(NHttpClientConnection conn, HttpException e) {
        String message = this.getErrorMessage("HTTP protocol violation : " + e.getMessage(), conn);
        log.error((Object)message, (Throwable)e);
        this.checkAxisRequestComplete(conn, 101506, message, (Exception)((Object)e));
        this.shutdownConnection(conn, true, "HTTP protocol violation : " + e.getMessage());
    }

    public void exception(NHttpClientConnection conn, IOException e) {
        String message = this.getErrorMessage("I/O error : " + e.getMessage(), conn);
        if (message.toLowerCase().indexOf("reset") != -1) {
            log.warn((Object)message);
        } else {
            log.error((Object)message, (Throwable)e);
        }
        this.checkAxisRequestComplete(conn, 101500, message, e);
        this.shutdownConnection(conn, true, "I/O error : " + e.getMessage());
    }

    private String getErrorMessage(String message, NHttpClientConnection conn) {
        if (conn != null && conn instanceof DefaultNHttpClientConnection) {
            DefaultNHttpClientConnection c = (DefaultNHttpClientConnection)conn;
            Axis2HttpRequest axis2Request = (Axis2HttpRequest)conn.getContext().getAttribute(AXIS2_HTTP_REQUEST);
            if (c.getRemoteAddress() != null) {
                return message + " For : " + c.getRemoteAddress().getHostAddress() + ":" + c.getRemotePort() + (axis2Request != null ? " For Request : " + axis2Request : "");
            }
        }
        return message;
    }

    private void checkAxisRequestComplete(NHttpClientConnection conn, int errorCode, String errorMessage, Exception exceptionToRaise) {
        Axis2HttpRequest axis2Request = (Axis2HttpRequest)conn.getContext().getAttribute(AXIS2_HTTP_REQUEST);
        if (axis2Request != null && !axis2Request.isCompleted()) {
            this.markRequestCompletedWithError(axis2Request, errorCode, errorMessage, exceptionToRaise);
        }
    }

    protected void markRequestCompletedWithError(Axis2HttpRequest axis2Request, final int errorCode, final String errorMessage, final Exception exceptionToRaise) {
        axis2Request.setCompleted(true);
        if (errorCode == -1 && errorMessage == null && exceptionToRaise == null) {
            return;
        }
        final MessageContext mc = axis2Request.getMsgContext();
        if (mc.getAxisOperation() != null && mc.getAxisOperation().getMessageReceiver() != null) {
            if (this.metrics != null) {
                if (this.metrics.getLevel() == 2) {
                    if (errorCode == 101504) {
                        this.metrics.incrementTimeoutsReceiving(mc);
                    } else {
                        this.metrics.incrementFaultsSending(errorCode, mc);
                    }
                } else if (errorCode == 101504) {
                    this.metrics.incrementTimeoutsReceiving();
                } else {
                    this.metrics.incrementFaultsSending();
                }
            }
            this.workerPool.execute(new Runnable(){

                @Override
                public void run() {
                    MessageReceiver mr = mc.getAxisOperation().getMessageReceiver();
                    try {
                        AxisFault axisFault = exceptionToRaise != null ? new AxisFault(errorMessage, (Throwable)exceptionToRaise) : new AxisFault(errorMessage);
                        MessageContext nioFaultMessageContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mc, (Throwable)axisFault);
                        SOAPEnvelope envelope = nioFaultMessageContext.getEnvelope();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Sending Fault for Request with Message ID : " + mc.getMessageID()));
                        }
                        nioFaultMessageContext.setProperty("SENDING_FAULT", (Object)Boolean.TRUE);
                        nioFaultMessageContext.setProperty("ERROR_MESSAGE", (Object)errorMessage);
                        if (errorCode != -1) {
                            nioFaultMessageContext.setProperty("ERROR_CODE", (Object)errorCode);
                        }
                        if (exceptionToRaise != null) {
                            nioFaultMessageContext.setProperty("ERROR_DETAIL", (Object)exceptionToRaise.toString());
                            nioFaultMessageContext.setProperty("ERROR_EXCEPTION", (Object)exceptionToRaise);
                            envelope.getBody().getFault().getDetail().setText(exceptionToRaise.toString());
                        } else {
                            nioFaultMessageContext.setProperty("ERROR_DETAIL", (Object)errorMessage);
                            envelope.getBody().getFault().getDetail().setText(errorMessage);
                        }
                        nioFaultMessageContext.setProperty(ClientHandler.CLIENT_CONNECTION_DEBUG, mc.getProperty(ClientHandler.CLIENT_CONNECTION_DEBUG));
                        mr.receive(nioFaultMessageContext);
                    }
                    catch (AxisFault af) {
                        log.error((Object)"Unable to report back failure to the message receiver", (Throwable)af);
                    }
                }
            });
        }
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        SharedInputBuffer inBuf = (SharedInputBuffer)context.getAttribute(RESPONSE_SINK_BUFFER);
        try {
            int bytesRead = inBuf.consumeContent(decoder, (IOControl)conn);
            if (this.metrics != null && bytesRead > 0) {
                if (this.metrics.getLevel() == 2) {
                    this.metrics.incrementBytesReceived(this.getMessageContext(conn), bytesRead);
                } else {
                    this.metrics.incrementBytesReceived(bytesRead);
                }
            }
            if (decoder.isCompleted()) {
                this.setServerContextAttribute("RES_ARRIVAL_TIME", System.currentTimeMillis(), conn);
                ClientConnectionDebug ccd = (ClientConnectionDebug)conn.getContext().getAttribute(CLIENT_CONNECTION_DEBUG);
                if (ccd != null) {
                    ccd.recordResponseCompletionTime();
                }
                if (this.metrics != null) {
                    if (this.metrics.getLevel() == 2) {
                        MessageContext mc = this.getMessageContext(conn);
                        this.metrics.incrementMessagesReceived(mc);
                        this.metrics.notifyReceivedMessageSize(mc, conn.getMetrics().getReceivedBytesCount());
                        this.metrics.notifySentMessageSize(mc, conn.getMetrics().getSentBytesCount());
                        this.metrics.reportResponseCode(mc, response.getStatusLine().getStatusCode());
                    } else {
                        this.metrics.incrementMessagesReceived();
                        this.metrics.notifyReceivedMessageSize(conn.getMetrics().getReceivedBytesCount());
                        this.metrics.notifySentMessageSize(conn.getMetrics().getSentBytesCount());
                    }
                }
                conn.getMetrics().reset();
                if (context.getAttribute("DISCARD_ON_COMPLETE") != null) {
                    try {
                        ConnectionPool.forget(conn);
                        this.shutdownConnection(conn, false, null);
                        context.removeAttribute(RESPONSE_SINK_BUFFER);
                        context.removeAttribute(REQUEST_SOURCE_BUFFER);
                    }
                    catch (Exception ignore) {}
                } else if (!this.connStrategy.keepAlive(response, context)) {
                    this.shutdownConnection(conn, false, null);
                    context.removeAttribute(RESPONSE_SINK_BUFFER);
                    context.removeAttribute(REQUEST_SOURCE_BUFFER);
                } else {
                    ConnectionPool.release(conn);
                }
            }
        }
        catch (IOException e) {
            if (this.metrics != null) {
                if (this.metrics.getLevel() == 2) {
                    this.metrics.incrementFaultsReceiving(101501, this.getMessageContext(conn));
                } else {
                    this.metrics.incrementFaultsReceiving();
                }
            }
            this.handleException("I/O Error at inputReady : " + e.getMessage(), e, conn);
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        SharedOutputBuffer outBuf = (SharedOutputBuffer)context.getAttribute(REQUEST_SOURCE_BUFFER);
        if (outBuf == null) {
            return;
        }
        try {
            ClientConnectionDebug ccd;
            int bytesWritten = outBuf.produceContent(encoder, (IOControl)conn);
            if (this.metrics != null) {
                if (bytesWritten > 0) {
                    if (this.metrics.getLevel() == 2) {
                        this.metrics.incrementBytesSent(this.getMessageContext(conn), bytesWritten);
                    } else {
                        this.metrics.incrementBytesSent(bytesWritten);
                    }
                }
                if (encoder.isCompleted()) {
                    if (this.metrics.getLevel() == 2) {
                        this.metrics.incrementMessagesSent(this.getMessageContext(conn));
                    } else {
                        this.metrics.incrementMessagesSent();
                    }
                }
            }
            if (encoder.isCompleted() && (ccd = (ClientConnectionDebug)context.getAttribute(CLIENT_CONNECTION_DEBUG)) != null) {
                ccd.recordRequestCompletionTime();
            }
        }
        catch (IOException e) {
            if (this.metrics != null) {
                if (this.metrics.getLevel() == 2) {
                    this.metrics.incrementFaultsSending(101500, this.getMessageContext(conn));
                } else {
                    this.metrics.incrementFaultsSending();
                }
            }
            this.handleException("I/O Error at outputReady : " + e.getMessage(), e, conn);
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        Header contentType;
        Axis2HttpRequest req;
        this.setServerContextAttribute("RES_HEADER_ARRIVAL_TIME", System.currentTimeMillis(), conn);
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        if (response.getStatusLine().getStatusCode() == 100) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Received a 100 Continue response");
            }
            return;
        }
        ClientConnectionDebug ccd = (ClientConnectionDebug)conn.getContext().getAttribute(CLIENT_CONNECTION_DEBUG);
        if (ccd != null) {
            ccd.recordResponseStartTime(response.getStatusLine().toString());
        }
        if ((req = (Axis2HttpRequest)conn.getContext().getAttribute(AXIS2_HTTP_REQUEST)) != null) {
            req.setCompleted(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response Received for Request : " + req));
            }
            if (!req.isSendingCompleted()) {
                req.getMsgContext().setProperty("ERROR_CODE", (Object)101509);
                SharedOutputBuffer outputBuffer = (SharedOutputBuffer)conn.getContext().getAttribute(REQUEST_SOURCE_BUFFER);
                if (outputBuffer != null) {
                    outputBuffer.shutdown();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remote server aborted request being sent and replied : " + conn + " for request : " + conn.getContext().getAttribute("HTTP_REQ_METHOD")));
                }
                context.setAttribute("DISCARD_ON_COMPLETE", (Object)Boolean.TRUE);
                if (this.metrics != null) {
                    this.metrics.incrementFaultsSending(101509, req.getMsgContext());
                }
            }
        }
        switch (response.getStatusLine().getStatusCode()) {
            case 202: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received a 202 Accepted response");
                }
                SharedInputBuffer inputBuffer = new SharedInputBuffer(8, this.allocator);
                context.setAttribute(RESPONSE_SINK_BUFFER, (Object)inputBuffer);
                MessageContext outMsgCtx = (MessageContext)context.getAttribute(OUTGOING_MESSAGE_CONTEXT);
                MessageReceiver mr = outMsgCtx.getAxisOperation().getMessageReceiver();
                if (!outMsgCtx.isPropertyTrue("IGNORE_SC_ACCEPTED")) {
                    try {
                        MessageContext responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
                        if (responseMsgCtx == null || outMsgCtx.getOptions().isUseSeparateListener() || outMsgCtx.getOperationContext().isComplete()) {
                            if (responseMsgCtx != null && responseMsgCtx.getProperty("synapse.send") == null) {
                                return;
                            }
                        } else if (outMsgCtx.getOptions().isUseSeparateListener()) {
                            this.setHeaders(context, response, outMsgCtx, responseMsgCtx);
                            outMsgCtx.setProperty("HTTP_202_RECEIVED", (Object)"true");
                            mr.receive(outMsgCtx);
                            return;
                        }
                        if (responseMsgCtx == null) {
                            return;
                        }
                        this.setHeaders(context, response, outMsgCtx, responseMsgCtx);
                        responseMsgCtx.setServerSide(true);
                        responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
                        responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
                        responseMsgCtx.setTransportIn(outMsgCtx.getTransportIn());
                        responseMsgCtx.setTransportOut(outMsgCtx.getTransportOut());
                        responseMsgCtx.setAxisMessage(outMsgCtx.getAxisOperation().getMessage("In"));
                        responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
                        responseMsgCtx.setConfigurationContext(outMsgCtx.getConfigurationContext());
                        responseMsgCtx.setTo(null);
                        if (!outMsgCtx.isDoingREST() && !outMsgCtx.isSOAP11()) {
                            responseMsgCtx.setEnvelope(OMAbstractFactory.getSOAP12Factory().getDefaultEnvelope());
                        } else {
                            responseMsgCtx.setEnvelope(OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope());
                        }
                        responseMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
                        responseMsgCtx.setProperty("SC_ACCEPTED", (Object)Boolean.TRUE);
                        mr.receive(responseMsgCtx);
                    }
                    catch (AxisFault af) {
                        log.debug((Object)"Unable to report back 202 Accepted state to the message receiver");
                    }
                }
                return;
            }
            case 200: {
                this.processResponse(conn, context, response);
                return;
            }
            case 500: {
                if (this.warnOnHttp500(response)) {
                    log.warn((Object)this.getErrorMessage("Received an internal server error : " + response.getStatusLine().getReasonPhrase(), conn));
                }
                this.processResponse(conn, context, response);
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.getErrorMessage("HTTP status code received : " + response.getStatusLine().getStatusCode() + " :: " + response.getStatusLine().getReasonPhrase(), conn));
        }
        if ((contentType = response.getFirstHeader(CONTENT_TYPE)) != null) {
            if (contentType.getValue().indexOf("text/xml") >= 0 || contentType.getValue().indexOf("application/soap+xml") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received an unexpected response with a SOAP payload");
                }
            } else if (contentType.getValue().indexOf("html") == -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received an unexpected response with a POX/REST payload");
                }
            } else {
                log.warn((Object)this.getErrorMessage("Received an unexpected response - of content type : " + contentType.getValue() + " and status code : " + response.getStatusLine().getStatusCode() + " with reason : " + response.getStatusLine().getReasonPhrase(), conn));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)this.getErrorMessage("Received a response - without a content type with status code : " + response.getStatusLine().getStatusCode() + " and reason : " + response.getStatusLine().getReasonPhrase(), conn));
        }
        this.processResponse(conn, context, response);
    }

    private void setHeaders(HttpContext context, HttpResponse response, MessageContext outMsgCtx, MessageContext responseMsgCtx) {
        Header[] headers = response.getAllHeaders();
        if (headers != null && headers.length > 0) {
            TreeMap<String, String> headerMap = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            String endpointURLPrefix = (String)context.getAttribute("ENDPOINT_PREFIX");
            String servicePrefix = (String)outMsgCtx.getProperty("SERVICE_PREFIX");
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                if ("Location".equals(header.getName()) && endpointURLPrefix != null && servicePrefix != null) {
                    try {
                        URI serviceURI = new URI(servicePrefix);
                        URI endpointURI = new URI(endpointURLPrefix);
                        URI locationURI = new URI(header.getValue());
                        if (!locationURI.getHost().equalsIgnoreCase(endpointURI.getHost())) continue;
                        URI newURI = new URI(locationURI.getScheme(), locationURI.getUserInfo(), serviceURI.getHost(), serviceURI.getPort(), locationURI.getPath(), locationURI.getQuery(), locationURI.getFragment());
                        headerMap.put(header.getName(), newURI.toString());
                        responseMsgCtx.setProperty("SERVICE_PREFIX", outMsgCtx.getProperty("SERVICE_PREFIX"));
                    }
                    catch (URISyntaxException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                headerMap.put(header.getName(), header.getValue());
            }
            responseMsgCtx.setProperty("TRANSPORT_HEADERS", headerMap);
        }
    }

    private boolean warnOnHttp500(HttpResponse response) {
        String messageContentType;
        if (this.warnOnHttp500 == null || this.warnOnHttp500.length == 0) {
            return true;
        }
        for (String contentType : this.warnOnHttp500) {
            if (contentType != null && !contentType.trim().equals("*")) continue;
            return true;
        }
        Header contentTypeHeader = response.getFirstHeader(CONTENT_TYPE);
        if (contentTypeHeader == null) {
            messageContentType = "none";
        } else {
            messageContentType = contentTypeHeader.getValue();
            if (messageContentType == null || messageContentType.trim().length() == 0) {
                messageContentType = "none";
            }
        }
        for (String contentType : this.warnOnHttp500) {
            if (!messageContentType.startsWith(contentType)) continue;
            return true;
        }
        return false;
    }

    private void processResponse(NHttpClientConnection conn, HttpContext context, HttpResponse response) {
        SharedInputBuffer inputBuffer = null;
        MessageContext outMsgContext = (MessageContext)context.getAttribute(OUTGOING_MESSAGE_CONTEXT);
        String endptPrefix = (String)context.getAttribute("ENDPOINT_PREFIX");
        String requestMethod = (String)context.getAttribute("HTTP_REQ_METHOD");
        int statusCode = response.getStatusLine().getStatusCode();
        boolean expectEntityBody = false;
        if (!"HEAD".equals(requestMethod) && !"OPTIONS".equals(requestMethod) && statusCode >= 200 && statusCode != 204 && statusCode != 304 && statusCode != 205) {
            expectEntityBody = true;
        }
        if (expectEntityBody) {
            inputBuffer = new SharedInputBuffer(this.cfg.getBufferSize(), this.allocator);
            context.setAttribute(RESPONSE_SINK_BUFFER, (Object)inputBuffer);
            BasicHttpEntity entity = new BasicHttpEntity();
            if (response.getStatusLine().getProtocolVersion().greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            response.setEntity((HttpEntity)entity);
            context.setAttribute("http.response", (Object)response);
        } else {
            conn.resetInput();
            conn.resetOutput();
            if (context.getAttribute("DISCARD_ON_COMPLETE") != null || !this.connStrategy.keepAlive(response, context)) {
                try {
                    ConnectionPool.forget(conn);
                    this.shutdownConnection(conn, false, null);
                    context.removeAttribute(RESPONSE_SINK_BUFFER);
                    context.removeAttribute(REQUEST_SOURCE_BUFFER);
                }
                catch (Exception ignore) {}
            } else {
                ConnectionPool.release(conn);
            }
        }
        this.workerPool.execute((Runnable)new ClientWorker(this.cfgCtx, (InputStream)(inputBuffer == null ? null : new ContentInputStream((ContentInputBuffer)inputBuffer)), response, outMsgContext, endptPrefix));
    }

    public void execute(Runnable task) {
        this.workerPool.execute(task);
    }

    private void shutdownConnection(NHttpClientConnection conn, boolean isError, String errorMsg) {
        SharedInputBuffer inputBuffer;
        HttpContext context;
        SharedOutputBuffer outputBuffer;
        if (conn instanceof HttpInetConnection) {
            HttpInetConnection inetConnection = (HttpInetConnection)conn;
            if (log.isWarnEnabled() && (isError || log.isDebugEnabled())) {
                String msg = "Connection to remote address : " + inetConnection.getRemoteAddress() + ":" + inetConnection.getRemotePort() + " from local address : " + inetConnection.getLocalAddress() + ":" + inetConnection.getLocalPort() + " is closed!" + (errorMsg != null ? " - On error : " + errorMsg : "");
                if (isError) {
                    log.warn((Object)msg);
                } else {
                    log.debug((Object)msg);
                }
            }
            if (this.countConnections) {
                this.removeConnectionRecord(inetConnection);
            }
        }
        if ((outputBuffer = (SharedOutputBuffer)(context = conn.getContext()).getAttribute(REQUEST_SOURCE_BUFFER)) != null) {
            outputBuffer.close();
        }
        if ((inputBuffer = (SharedInputBuffer)context.getAttribute(RESPONSE_SINK_BUFFER)) != null) {
            inputBuffer.close();
        }
        try {
            conn.shutdown();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        context.removeAttribute(RESPONSE_SINK_BUFFER);
        context.removeAttribute(REQUEST_SOURCE_BUFFER);
        context.removeAttribute(CLIENT_CONNECTION_DEBUG);
        context.removeAttribute(CONNECTION_CREATION_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionRecord(HttpInetConnection inetConnection) {
        AtomicInteger connections = this.openConnections.get(inetConnection.getRemoteAddress().getHostName() + ":" + inetConnection.getRemotePort());
        if (connections == null) {
            connections = this.openConnections.get(inetConnection.getRemoteAddress().getHostAddress() + ":" + inetConnection.getRemotePort());
        }
        if (connections != null) {
            int no = connections.getAndDecrement();
            this.lock.lock();
            try {
                if (no == 0) {
                    if (null == this.openConnections.remove(inetConnection.getRemoteAddress().getHostName() + ":" + inetConnection.getRemotePort())) {
                    } else {
                        this.openConnections.remove(inetConnection.getRemoteAddress().getHostAddress() + ":" + inetConnection.getRemotePort());
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordConnection(NHttpClientConnection conn) {
        if (conn instanceof HttpInetConnection) {
            HttpInetConnection inetConnection = (HttpInetConnection)conn;
            AtomicInteger connections = this.openConnections.get(inetConnection.getRemoteAddress().getHostName() + ":" + inetConnection.getRemotePort());
            if (connections == null) {
                connections = this.openConnections.get(inetConnection.getRemoteAddress().getHostAddress() + ":" + inetConnection.getRemotePort());
            }
            this.lock.lock();
            try {
                if (connections == null) {
                    connections = new AtomicInteger();
                    if (inetConnection.getRemoteAddress().getHostName() != null) {
                        this.openConnections.put(inetConnection.getRemoteAddress().getHostName() + ":" + inetConnection.getRemotePort(), connections);
                    } else {
                        this.openConnections.put(inetConnection.getRemoteAddress().getHostAddress() + ":" + inetConnection.getRemotePort(), connections);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
            connections.getAndIncrement();
        }
    }

    private HttpProcessor getHttpProcessor() {
        return new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent("Synapse-HttpComponents-NIO"), new RequestExpectContinue(false)});
    }

    public int getActiveCount() {
        return this.workerPool.getActiveCount();
    }

    public int getQueueSize() {
        return this.workerPool.getQueueSize();
    }

    public void stop() {
        this.threadingView.destroy();
        try {
            this.workerPool.shutdown(1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleException(String msg, Exception e, NHttpClientConnection conn) {
        if (msg.toLowerCase().indexOf("reset") != -1) {
            log.warn((Object)msg);
        } else {
            log.error((Object)msg, (Throwable)e);
        }
        if (conn != null) {
            this.shutdownConnection(conn, true, msg);
        }
    }

    private MessageContext getMessageContext(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        Axis2HttpRequest axis2Req = (Axis2HttpRequest)context.getAttribute(AXIS2_HTTP_REQUEST);
        if (axis2Req != null) {
            return axis2Req.getMsgContext();
        }
        return null;
    }

    private void setServerContextAttribute(String key, Object value, NHttpClientConnection conn) {
        Object outTransport;
        MessageContext msgCtx = this.getMessageContext(conn);
        if (msgCtx != null && (outTransport = msgCtx.getProperty("OutTransportInfo")) != null && outTransport instanceof ServerWorker) {
            HttpContext context = ((ServerWorker)outTransport).getConn().getContext();
            context.setAttribute(key, value);
        }
    }
}

