/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.synapse.transport.amqp.AMQPOutTransportInfo;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportMessage;
import org.apache.synapse.transport.amqp.AMQPTransportUtils;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactoryManager;
import org.apache.synapse.transport.amqp.pollingtask.AMQPSimpleConsumerTask;
import org.apache.synapse.transport.amqp.sendertask.AMQPSender;
import org.apache.synapse.transport.amqp.sendertask.AMQPSenderCache;
import org.apache.synapse.transport.amqp.sendertask.AMQPSenderFactory;
import org.apache.synapse.transport.amqp.tx.AMQPTransportProducerTx;

public class AMQPTransportSender
extends AbstractTransportSender {
    private AMQPTransportConnectionFactoryManager connectionFactoryManager;
    private ExecutorService connectionFactoryES;
    private AMQPSenderCache cache;
    private Map<String, Semaphore> responseTracker;
    private Map<String, AMQPTransportMessage> responseMessage;
    private ExecutorService responseHandlingPool;
    private long semaphoreTimeOut;

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
        this.connectionFactoryES = Executors.newFixedThreadPool(AMQPTransportUtils.getIntProperty("connection-factory-pool-size", 20));
        this.responseHandlingPool = Executors.newFixedThreadPool(AMQPTransportUtils.getIntProperty("response-handling-pool-size", 20));
        this.connectionFactoryManager = new AMQPTransportConnectionFactoryManager();
        this.connectionFactoryManager.addConnectionFactories((ParameterInclude)transportOut, this.connectionFactoryES);
        this.semaphoreTimeOut = AMQPTransportUtils.getLongProperty("semaphore-time-out", 86400L);
        this.cache = new AMQPSenderCache(new ConcurrentHashMap<Integer, AMQPSender>());
        this.responseTracker = new ConcurrentHashMap<String, Semaphore>();
        this.responseMessage = new ConcurrentHashMap<String, AMQPTransportMessage>();
        this.log.info((Object)"AMQP transport sender initializing..");
    }

    public void stop() {
        super.stop();
        try {
            this.connectionFactoryManager.shutDownConnectionFactories();
        }
        catch (AMQPTransportException e) {
            this.log.error((Object)"Error while shutting down connection factories, continue anyway...", (Throwable)e);
        }
        this.cache.clean();
        this.responseTracker.clear();
        this.responseMessage.clear();
        this.connectionFactoryES.shutdown();
        this.responseHandlingPool.shutdown();
    }

    public void sendMessage(MessageContext msgCtx, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        block31: {
            AMQPSender amqpSender;
            Integer hashKey = null;
            HashMap<String, String> params = null;
            String replyTo = null;
            MessageContext replyMsgCtx = msgCtx.getOperationContext().getMessageContext("In");
            if (replyMsgCtx != null) {
                replyTo = (String)replyMsgCtx.getProperty("AMQP_REPLY_TO");
            }
            if (replyTo != null) {
                hashKey = replyTo.hashCode();
                params = new HashMap<String, String>();
                params.put("transport.amqp.QueueName", replyTo);
                String conFacName = (String)msgCtx.getOperationContext().getMessageContext("In").getProperty("RESPONSE_CONNECTION_FACTORY_NAME");
                if (conFacName == null) {
                    throw new AxisFault("A message was received with 'reply to' set. But no reply connection factory name found. Define the parameter 'transport.amqp.ResponseConnectionFactoryName' as a service parameter. This response message will be dropped!");
                }
                params.put("transport.amqp.ConnectionFactoryName", conFacName);
            } else if (targetEPR != null) {
                hashKey = new Integer(targetEPR.hashCode());
                try {
                    params = AMQPTransportUtils.parseAMQPUri(targetEPR);
                }
                catch (AMQPTransportException e) {
                    throw new AxisFault("Error while parsing the AMQP epr '" + targetEPR + "'", (Throwable)e);
                }
            } else if (outTransportInfo != null && outTransportInfo instanceof AMQPOutTransportInfo) {
                AMQPOutTransportInfo info = (AMQPOutTransportInfo)outTransportInfo;
                params = info.getParams();
            } else {
                throw new AxisFault("Could not determine the endpoint information to deliver the message");
            }
            if (this.cache.hit(hashKey)) {
                amqpSender = this.cache.get(hashKey);
            } else {
                try {
                    amqpSender = AMQPSenderFactory.createAMQPSender(this.connectionFactoryManager, params);
                    this.cache.add(hashKey, amqpSender);
                }
                catch (IOException e) {
                    throw new AxisFault("Could not create the AMQP sender", (Throwable)e);
                }
            }
            try {
                String useTx;
                AMQPTransportProducerTx tx;
                String correlationId = (String)msgCtx.getProperty("AMQP_CORRELATION_ID");
                if (correlationId == null) {
                    correlationId = msgCtx.getMessageID();
                }
                boolean isInOut = this.waitForSynchronousResponse(msgCtx);
                Semaphore available = null;
                if (isInOut) {
                    replyTo = (String)msgCtx.getProperty("AMQP_REPLY_TO");
                    if (replyTo == null) {
                        replyTo = UUID.randomUUID().toString();
                    }
                    available = new Semaphore(0, true);
                    this.responseTracker.put(correlationId, available);
                }
                if ((tx = "lwpc".equals(useTx = (String)msgCtx.getProperty("AMQP_PRODUCER_TX")) ? new AMQPTransportProducerTx(true, amqpSender.getChannel()) : ("tx".equals(useTx) ? new AMQPTransportProducerTx(false, amqpSender.getChannel()) : null)) != null) {
                    try {
                        tx.start();
                    }
                    catch (IOException e) {
                        throw new AxisFault("Error while initiation tx for message '" + msgCtx.getMessageID() + "'", (Throwable)e);
                    }
                }
                amqpSender.sendAMQPMessage(msgCtx, correlationId, replyTo);
                if (tx != null) {
                    try {
                        tx.end();
                    }
                    catch (IOException e) {
                        throw new AxisFault("Error while terminating tx for message '" + msgCtx.getMessageID() + "'", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        this.log.error((Object)("Error while terminating tx for message '" + msgCtx.getMessageID() + "'"), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
                if (!isInOut) break block31;
                new AMQPSimpleConsumerTask(this.responseHandlingPool, amqpSender.getChannel(), replyTo, this.responseTracker, this.responseMessage).consume();
                try {
                    available.tryAcquire(this.semaphoreTimeOut, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.responseTracker.remove(correlationId);
                AMQPTransportMessage msg = this.responseMessage.get(correlationId);
                if (msg != null) {
                    this.handleSyncResponse(msgCtx, msg, msg.getContentType());
                } else {
                    this.log.warn((Object)("The semaphore with id '" + correlationId + "' was time out while " + "waiting for a response, sending a fault to client.."));
                    this.sendFault(msgCtx, new Exception("Times out occurs while waiting for a response"));
                }
            }
            catch (AMQPTransportException e) {
                throw new AxisFault("Could not retrieve the connection factory information", (Throwable)e);
            }
            catch (IOException e) {
                throw new AxisFault("Could not produce the message into the destination", (Throwable)e);
            }
        }
    }

    private void handleSyncResponse(MessageContext requestMsgCtx, AMQPTransportMessage message, String requestContentType) throws AxisFault {
        try {
            MessageContext responseMsgCtx = this.createResponseMessageContext(requestMsgCtx);
            responseMsgCtx.setProperty("messageType", requestMsgCtx.getProperty("messageType"));
            responseMsgCtx.setProperty("ContentType", requestMsgCtx.getProperty("ContentType"));
            String contentType = message.getContentType();
            if (contentType == null) {
                contentType = this.inferContentType(requestContentType, responseMsgCtx);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getBody());
            Builder builder = BuilderUtil.getBuilderFromSelector((String)contentType, (MessageContext)requestMsgCtx);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.processDocument((InputStream)inputStream, contentType, responseMsgCtx);
            responseMsgCtx.setEnvelope(envelope);
            String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            responseMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)(contentType.indexOf("; charset=") > 0 ? charSetEnc : "UTF-8"));
            responseMsgCtx.setProperty("TRANSPORT_HEADERS", message.getHeaders());
            if (message.getSoapAction() != null) {
                responseMsgCtx.setSoapAction(message.getSoapAction());
            }
            AxisEngine.receive((MessageContext)responseMsgCtx);
        }
        catch (AxisFault axisFault) {
            this.handleException("Could not handle the response message ", (Exception)((Object)axisFault));
        }
    }

    private void sendFault(MessageContext msgContext, Exception e) {
        try {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
            faultContext.setProperty("ERROR_MESSAGE", (Object)e.getMessage());
            faultContext.setProperty("SENDING_FAULT", (Object)Boolean.TRUE);
            AxisEngine.sendFault((MessageContext)faultContext);
        }
        catch (AxisFault axisFault) {
            this.log.fatal((Object)"Could not create the fault message.", (Throwable)axisFault);
        }
    }

    private String inferContentType(String requestContentType, MessageContext responseMsgCtx) {
        Object cTypeProperty = responseMsgCtx.getProperty("ContentType");
        if (cTypeProperty != null) {
            return cTypeProperty.toString();
        }
        Parameter cTypeParam = this.cfgCtx.getAxisConfiguration().getParameter("ContentType");
        if (cTypeParam != null) {
            return cTypeParam.getValue().toString();
        }
        if (requestContentType != null) {
            return requestContentType;
        }
        return "application/xml";
    }
}

