/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axiom.util.stax.WrappedTextNodeStreamReader;
import org.apache.axis2.transport.base.BaseConstants;

public class TextFileDataSource
extends OMDataSourceExtBase {
    private final OverflowBlob overflowBlob;
    private final Charset charset;

    public TextFileDataSource(OverflowBlob overflowBlob, Charset charset) {
        this.overflowBlob = overflowBlob;
        this.charset = charset;
    }

    public static OMSourcedElement createOMSourcedElement(OverflowBlob overflowBlob, Charset charset) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        TextFileDataSource txtFileDS = new TextFileDataSource(overflowBlob, charset);
        return fac.createOMElement((OMDataSource)txtFileDS, BaseConstants.DEFAULT_TEXT_WRAPPER);
    }

    public void serialize(OutputStream out, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(out, format);
        this.serialize((XMLStreamWriter)writer);
        writer.flush();
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter xmlWriter = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer));
        xmlWriter.setOutputFormat(format);
        this.serialize((XMLStreamWriter)xmlWriter);
        xmlWriter.flush();
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        serializer.serialize(this.getReader(), xmlWriter);
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        InputStream is;
        try {
            is = this.overflowBlob.getInputStream();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
        return new WrappedTextNodeStreamReader(BaseConstants.DEFAULT_TEXT_WRAPPER, (Reader)new InputStreamReader(is, this.charset));
    }

    public Object getObject() {
        return this.overflowBlob;
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public OMDataSourceExt copy() {
        return new TextFileDataSource(this.overflowBlob, this.charset);
    }
}

