/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.endpoints.DynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.dispatch.SessionInformation;
import org.apache.synapse.util.Replicator;

public class SALSessions {
    private static final SALSessions INSTANCE = new SALSessions();
    private static final Log log = LogFactory.getLog(SALSessions.class);
    private static final String SESSION_IDS = "synapse.salep.sessionids.";
    private ConfigurationContext configCtx;
    private boolean isClustered = false;
    private boolean initialized = false;
    private final Map<List<String>, List<Endpoint>> namesToEndpointsMap = new HashMap<List<String>, List<Endpoint>>();
    private final Map<String, SessionInformation> establishedSessions = new HashMap<String, SessionInformation>();
    private final Map<String, Map<String, Endpoint>> childEndpoints = new HashMap<String, Map<String, Endpoint>>();

    private SALSessions() {
    }

    public static SALSessions getInstance() {
        return INSTANCE;
    }

    public void initialize(boolean isClusteringEnable, ConfigurationContext cc) {
        if (!this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing SALSessions instance. Environment : " + (isClusteringEnable ? " clustered" : " local")));
            }
            if (isClusteringEnable) {
                this.isClustered = isClusteringEnable;
                this.configCtx = cc;
            }
            this.initialized = true;
        }
    }

    public void registerChildren(Endpoint endpoint, List<Endpoint> endpoints) {
        if (this.isClustered) {
            String endpointName = endpoint.getName();
            this.validateInput(endpointName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering endpoints " + endpoints + " of " + endpointName));
            }
            if (!this.childEndpoints.containsKey(endpointName)) {
                HashMap<String, Endpoint> children = new HashMap<String, Endpoint>();
                children.put(endpointName, endpoint);
                this.fillMap(endpoints, children);
                this.childEndpoints.put(endpointName, children);
            }
        }
    }

    public void updateSession(MessageContext synCtx, String sessionID) {
        if (sessionID == null || "".equals(sessionID)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot find session ID. Returning null.");
            }
            return;
        }
        boolean createSession = false;
        SessionInformation oldSession = (SessionInformation)synCtx.getProperty("synapse.sal.endpoint.current.sessioninformation");
        List<Endpoint> endpoints = null;
        Member currentMember = null;
        if (oldSession == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Going to create a New session with id  " + sessionID));
            }
            endpoints = (List<Endpoint>)synCtx.getProperty("synapse.sal.endpoint.list");
            currentMember = (Member)synCtx.getProperty("synapse.sal.current.member");
            createSession = true;
        } else {
            String oldSessionID = oldSession.getId();
            if (!sessionID.equals(oldSessionID)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Renew the session : previous session id :" + oldSessionID + " new session id :" + sessionID));
                }
                this.removeSession(oldSessionID);
                endpoints = oldSession.getEndpointList();
                currentMember = oldSession.getMember();
                createSession = true;
            } else {
                SessionInformation information = this.getSessionInformation(oldSessionID);
                if (information == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Recovering lost session information for session id " + sessionID));
                    }
                    endpoints = oldSession.getEndpointList();
                    currentMember = oldSession.getMember();
                    createSession = true;
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Session with id : " + sessionID + " is still live."));
                }
            }
        }
        if (createSession) {
            SessionInformation newInformation = currentMember == null ? this.createSessionInformation(synCtx, sessionID, endpoints) : this.createSessionInformation(synCtx, sessionID, currentMember);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Establishing a session with id :" + sessionID + " and it's endpoint sequence : " + endpoints));
            }
            if (this.isClustered) {
                Replicator.setAndReplicateState(SESSION_IDS + sessionID, newInformation, this.configCtx);
            } else {
                this.establishedSessions.put(sessionID, newInformation);
            }
        }
    }

    public SessionInformation getSession(String sessionID) {
        SessionInformation information;
        if (sessionID == null || "".equals(sessionID)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot find session ID .Returning null");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving the endpoint from the session id " + sessionID));
        }
        if ((information = this.getSessionInformation(sessionID)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session information cannot be found for session id " + sessionID));
            }
            return null;
        }
        if (information.isExpired()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session has been expired for session with id: " + sessionID));
            }
            this.removeSession(sessionID);
            return null;
        }
        return information;
    }

    public List<Endpoint> getChildEndpoints(SessionInformation information) {
        List<Endpoint> endpoints = this.isClustered ? this.getEndpoints(information.getPath(), information.getRootEndpointName()) : information.getEndpointList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving endpoint sequence : " + endpoints + " for session " + information.getId()));
        }
        if (endpoints == null || endpoints.isEmpty()) {
            SALSessions.handleException("Session with id " + information.getId() + " is invalid ." + " A session must have a endpoint sequence associated with it");
        }
        ArrayList<Endpoint> toBeSent = new ArrayList<Endpoint>();
        toBeSent.addAll(endpoints);
        toBeSent.remove(0);
        return toBeSent;
    }

    public void removeSession(String sessionId) {
        if (sessionId == null || "".equals(sessionId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Session Id cannot be found.The session will not be removed.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing the session with the session Id " + sessionId));
        }
        if (this.isClustered) {
            Replicator.removeAndReplicateState(SESSION_IDS + sessionId, this.configCtx);
        } else {
            this.establishedSessions.remove(sessionId);
        }
    }

    public synchronized void clearSessions() {
        if (!this.initialized) {
            return;
        }
        try {
            if (this.isClustered) {
                ArrayList<String> toBeRemoved = new ArrayList<String>();
                Iterator props = this.configCtx.getPropertyNames();
                while (props.hasNext()) {
                    String key;
                    SessionInformation info;
                    Object name = props.next();
                    if (!(name instanceof String) || !((String)name).startsWith(SESSION_IDS) || (info = (SessionInformation)this.configCtx.getProperty(key = (String)name)) == null || !info.isExpired()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Clustered Environment :Expired session with id :" + key));
                    }
                    toBeRemoved.add(key);
                }
                if (!toBeRemoved.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Clearing expired sessions");
                    }
                    for (String key : toBeRemoved) {
                        Replicator.removeAndReplicateState(key, this.configCtx);
                    }
                }
            } else {
                ArrayList<String> toBeRemoved = new ArrayList<String>();
                for (SessionInformation information : this.establishedSessions.values()) {
                    if (information == null || !information.isExpired()) continue;
                    String id = information.getId();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Expired session with id :" + id));
                    }
                    toBeRemoved.add(id);
                }
                if (!toBeRemoved.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Clearing expired sessions");
                    }
                    this.establishedSessions.keySet().removeAll(toBeRemoved);
                }
            }
        }
        catch (Throwable ignored) {
            log.debug((Object)("Ignored error clearing sessions : Error " + ignored));
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public void reset() {
        if (!this.initialized) {
            return;
        }
        log.info((Object)"Clearing all states ");
        this.initialized = false;
        this.establishedSessions.clear();
        this.namesToEndpointsMap.clear();
        this.childEndpoints.clear();
    }

    private void fillMap(List<Endpoint> endpoints, Map<String, Endpoint> endpointsMap) {
        if (endpoints != null) {
            for (Endpoint endpoint : endpoints) {
                String endpointName = this.getEndpointName(endpoint);
                if (endpointsMap.containsKey(endpointName)) {
                    SALSessions.handleException("Endpoint Name with ' " + endpointName + "' already there. " + "Endpoint name must be unique.");
                }
                endpointsMap.put(endpointName, endpoint);
                this.fillMap(endpoint.getChildren(), endpointsMap);
            }
        }
    }

    private List<String> getEndpointNames(List<Endpoint> endpoints) {
        ArrayList<String> endpointNames = new ArrayList<String>();
        for (Endpoint endpoint : endpoints) {
            endpointNames.add(this.getEndpointName(endpoint));
        }
        return endpointNames;
    }

    private List<Endpoint> getEndpoints(List<String> endpointNames, String root) {
        if (endpointNames == null || endpointNames.isEmpty()) {
            SALSessions.handleException("Invalid session - path cannot be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving endpoint sequence for path " + endpointNames));
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (this.namesToEndpointsMap.containsKey(endpointNames)) {
            endpoints.addAll((Collection)this.namesToEndpointsMap.get(endpointNames));
            return endpoints;
        }
        Map<String, Endpoint> map = this.childEndpoints.get(root);
        assert (endpointNames != null);
        for (String endpointName : endpointNames) {
            Endpoint endpoint = null;
            if (map != null && ((endpoint = map.get(endpointName)) == null || endpoints.contains(endpoint)) && (map = this.childEndpoints.get(endpointName)) != null) {
                endpoint = map.get(endpointName);
            }
            if (endpoint == null) {
                SALSessions.handleException("Invalid session. Endpoint with name '" + endpointName + "' cannot found");
            }
            endpoints.add(endpoint);
        }
        this.namesToEndpointsMap.put(endpointNames, endpoints);
        return endpoints;
    }

    private void validateInput(String endpointName) {
        if (endpointName == null) {
            SALSessions.handleException("For proper clustered mode operation, all endpoints should be uniquely named");
        }
    }

    private String getEndpointName(Endpoint endpoint) {
        if (endpoint == null) {
            SALSessions.handleException("Endpoint cannot be null.");
        }
        assert (endpoint != null);
        String endpointName = endpoint.getName();
        if (endpointName == null && endpoint instanceof IndirectEndpoint) {
            endpointName = ((IndirectEndpoint)endpoint).getKey();
        }
        this.validateInput(endpointName);
        return endpointName;
    }

    private SessionInformation getSessionInformation(String sessionID) {
        if (this.isClustered) {
            return (SessionInformation)this.configCtx.getPropertyNonReplicable(SESSION_IDS + sessionID);
        }
        return this.establishedSessions.get(sessionID);
    }

    private SessionInformation createSessionInformation(MessageContext synCtx, String id, List<Endpoint> endpoints) {
        if (endpoints == null || endpoints.isEmpty()) {
            SALSessions.handleException("Invalid request to create sessions . Cannot find a endpoint sequence.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a session information for given session id  " + id + " with endpoint sequence " + endpoints));
        }
        long expireTimeWindow = -1L;
        assert (endpoints != null);
        for (Endpoint endpoint : endpoints) {
            if (!(endpoint instanceof SALoadbalanceEndpoint)) continue;
            long sessionsTimeout = ((SALoadbalanceEndpoint)endpoint).getSessionTimeout();
            if (expireTimeWindow == -1L) {
                expireTimeWindow = sessionsTimeout;
                continue;
            }
            if (expireTimeWindow <= sessionsTimeout) continue;
            expireTimeWindow = sessionsTimeout;
        }
        if (expireTimeWindow == -1L) {
            expireTimeWindow = synCtx.getConfiguration().getProperty("synapse.sal.endpoints.sesssion.timeout.default", 120000L);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("For session with id " + id + " : expiry time interval : " + expireTimeWindow));
        }
        long expiryTime = System.currentTimeMillis() + expireTimeWindow;
        Endpoint rootEndpoint = endpoints.get(0);
        SessionInformation information = new SessionInformation(id, endpoints, expiryTime);
        if (this.isClustered) {
            List<String> epNameList = this.getEndpointNames(endpoints);
            information.setPath(epNameList);
            information.setRootEndpointName(this.getEndpointName(rootEndpoint));
        }
        return information;
    }

    private SessionInformation createSessionInformation(MessageContext synCtx, String id, Member currentMember) {
        if (currentMember == null) {
            SALSessions.handleException("Invalid request to create sessions.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a session information for given session id  " + id + " with member Host:" + currentMember.getHostName() + " Port:" + currentMember.getPort()));
        }
        long expireTimeWindow = -1L;
        List endpoints = (List)synCtx.getProperty("synapse.sal.endpoint.list");
        assert (endpoints != null);
        for (Endpoint endpoint : endpoints) {
            if (!(endpoint instanceof DynamicLoadbalanceEndpoint)) continue;
            long sessionsTimeout = ((DynamicLoadbalanceEndpoint)endpoint).getSessionTimeout();
            if (expireTimeWindow == -1L) {
                expireTimeWindow = sessionsTimeout;
                continue;
            }
            if (expireTimeWindow <= sessionsTimeout) continue;
            expireTimeWindow = sessionsTimeout;
        }
        if (expireTimeWindow == -1L) {
            expireTimeWindow = synCtx.getConfiguration().getProperty("synapse.sal.endpoints.sesssion.timeout.default", 120000L);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("For session with id " + id + " : expiry time interval : " + expireTimeWindow));
        }
        long expiryTime = System.currentTimeMillis() + expireTimeWindow;
        Endpoint rootEndpoint = (Endpoint)endpoints.get(0);
        SessionInformation information = new SessionInformation(id, currentMember, expiryTime, expireTimeWindow);
        if (this.isClustered) {
            information.setRootEndpointName(this.getEndpointName(rootEndpoint));
        }
        return information;
    }
}

