/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public class ServiceLoadBalanceMembershipHandler
implements LoadBalanceMembershipHandler {
    private static final Log log = LogFactory.getLog(ServiceLoadBalanceMembershipHandler.class);
    private ConfigurationContext configCtx;
    private Map<String, DomainAlgorithmContext> hostDomainAlgorithmContextMap = new HashMap<String, DomainAlgorithmContext>();
    private ClusteringAgent clusteringAgent;

    public ServiceLoadBalanceMembershipHandler(Map<String, String> hostDomainMap, LoadbalanceAlgorithm algorithm, ConfigurationContext configCtx, boolean isClusteringEnabled, String endpointName) {
        for (Map.Entry<String, String> entry : hostDomainMap.entrySet()) {
            AlgorithmContext algorithmContext = new AlgorithmContext(isClusteringEnabled, configCtx, endpointName + "." + entry.getKey());
            this.hostDomainAlgorithmContextMap.put(entry.getKey(), new DomainAlgorithmContext(entry.getValue(), algorithm.clone(), algorithmContext));
        }
    }

    @Override
    public void init(Properties props, LoadbalanceAlgorithm algorithm) {
    }

    @Override
    public void setConfigurationContext(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.clusteringAgent = configCtx.getAxisConfiguration().getClusteringAgent();
        if (this.clusteringAgent == null) {
            String msg = "In order to enable load balancing across an Axis2 cluster, the cluster entry should be enabled in the axis2.xml file";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    @Override
    public ConfigurationContext getConfigurationContext() {
        return this.configCtx;
    }

    @Override
    public Member getNextApplicationMember(AlgorithmContext context) {
        throw new UnsupportedOperationException("This operation is invalid. Call getNextApplicationMember(String host)");
    }

    public Member getNextApplicationMember(String host) {
        DomainAlgorithmContext domainAlgorithmContext = this.getDomainAlgorithmContext(host);
        String lbDomain = domainAlgorithmContext.getDomain();
        LoadbalanceAlgorithm algorithm = domainAlgorithmContext.getAlgorithm();
        GroupManagementAgent groupMgtAgent = this.clusteringAgent.getGroupManagementAgent(lbDomain);
        if (groupMgtAgent == null) {
            String msg = "A LoadBalanceEventHandler has not been specified in the axis2.xml file for the domain " + lbDomain + " for host " + host;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        algorithm.setApplicationMembers(groupMgtAgent.getMembers());
        AlgorithmContext context = domainAlgorithmContext.getAlgorithmContext();
        return algorithm.getNextApplicationMember(context);
    }

    private DomainAlgorithmContext getDomainAlgorithmContext(String host) {
        DomainAlgorithmContext domainAlgorithmContext = this.hostDomainAlgorithmContextMap.get(host);
        if (domainAlgorithmContext == null) {
            int indexOfDot = host.indexOf(".");
            if (indexOfDot != -1) {
                domainAlgorithmContext = this.getDomainAlgorithmContext(host.substring(indexOfDot + 1));
            } else {
                throw new SynapseException("Domain not found for host" + host);
            }
        }
        return domainAlgorithmContext;
    }

    @Override
    public LoadbalanceAlgorithm getLoadbalanceAlgorithm() {
        return null;
    }

    @Override
    public Properties getProperties() {
        return null;
    }

    private static class DomainAlgorithmContext {
        private String domain;
        private AlgorithmContext algorithmContext;
        private LoadbalanceAlgorithm algorithm;

        private DomainAlgorithmContext(String domain, LoadbalanceAlgorithm algorithm, AlgorithmContext algorithmContext) {
            this.domain = domain;
            this.algorithm = algorithm;
            this.algorithmContext = algorithmContext;
        }

        public LoadbalanceAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public String getDomain() {
            return this.domain;
        }

        public AlgorithmContext getAlgorithmContext() {
            return this.algorithmContext;
        }
    }
}

