/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints.utils;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.algorithms.RoundRobin;

public class LoadbalanceAlgorithmFactory {
    private static Log log = LogFactory.getLog(LoadbalanceAlgorithmFactory.class);

    public static LoadbalanceAlgorithm createLoadbalanceAlgorithm(OMElement loadbalanceElement, List endpoints) {
        LoadbalanceAlgorithm algorithm = new RoundRobin(endpoints);
        OMAttribute policyAttribute = loadbalanceElement.getAttribute(new QName(null, "policy"));
        OMAttribute algoAttribute = loadbalanceElement.getAttribute(new QName(null, "algorithm"));
        if (policyAttribute != null && algoAttribute != null) {
            String msg = "You cannot specify both the 'policy' & 'algorithm' in the configuration. It is sufficient to provide only the 'algorithm'.";
            log.fatal((Object)msg);
            throw new SynapseException(msg);
        }
        if (algoAttribute != null) {
            String algorithmStr = algoAttribute.getAttributeValue().trim();
            try {
                algorithm = (LoadbalanceAlgorithm)Class.forName(algorithmStr).newInstance();
                algorithm.setEndpoints(endpoints);
            }
            catch (Exception e) {
                String msg = "Cannot instantiate LoadbalanceAlgorithm implementation class " + algorithmStr;
                log.fatal((Object)msg, (Throwable)e);
                throw new SynapseException(msg, e);
            }
        } else if (policyAttribute != null && !policyAttribute.getAttributeValue().trim().equals("roundRobin")) {
            String msg = "Unsupported algorithm " + policyAttribute.getAttributeValue().trim() + " specified. Please use the 'algorithm' attribute to specify the " + "correct loadbalance algorithm implementation.";
            log.fatal((Object)msg);
            throw new SynapseException(msg);
        }
        return algorithm;
    }

    public static LoadbalanceAlgorithm createLoadbalanceAlgorithm2(OMElement loadbalanceElement, List<Member> members) {
        LoadbalanceAlgorithm algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm(loadbalanceElement, null);
        algorithm.setApplicationMembers(members);
        return algorithm;
    }
}

